<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Sayfa başlığını ayarla
$page_title = "API Çağrı Logları";

// Header'ı dahil et (Oturum kontrolünü yapar)
require_once __DIR__ . '/includes/header.php';

// Sayfalama Ayarları
$limit = 50; // Sayfa başına gösterilecek log sayısı
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Toplam log sayısını al (sayfalama için)
$count_sql = "SELECT COUNT(*) as total FROM api_logs";
$count_result = $conn->query($count_sql);
$total_logs = ($count_result && $count_result->num_rows > 0) ? $count_result->fetch_assoc()['total'] : 0;
$total_pages = ceil($total_logs / $limit);

// Logları veritabanından çek (sayfalama ile)
$sql = "SELECT id, license_key_sent, domain_sent, ip_address, response_status, response_reason, response_message, checked_at
        FROM api_logs
        ORDER BY checked_at DESC
        LIMIT ? OFFSET ?";
$stmt = $conn->prepare($sql);
if(!$stmt){
     // Hata durumunda boş sonuç gibi davran
     error_log("API Logs - SQL Prepare Error: " . $conn->error);
     $logs = [];
     $total_logs = 0;
     $total_pages = 0;
} else {
    $stmt->bind_param("ii", $limit, $offset);
    $stmt->execute();
    $result = $stmt->get_result();
    $logs = ($result) ? $result->fetch_all(MYSQLI_ASSOC) : [];
    $stmt->close();
}

$conn->close();

?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-terminal-fill"></i> <?php echo htmlspecialchars($page_title); ?></h1>
    <!-- Buraya filtreleme veya log temizleme butonu eklenebilir -->
</div>

<div class="card shadow-sm">
    <div class="card-header">
        Son API İstekleri (Toplam: <?php echo $total_logs; ?>)
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <?php if (!empty($logs)): ?>
                <table class="table table-striped table-hover table-bordered table-sm">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Zaman</th>
                            <th>IP Adresi</th>
                            <th>Gönderilen Anahtar</th>
                            <th>Gönderilen Domain</th>
                            <th>Yanıt Durumu</th>
                            <th>Neden Kodu</th>
                            <th>Yanıt Mesajı</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($logs as $log): ?>
                            <tr>
                                <td><?php echo $log['id']; ?></td>
                                <td style="white-space: nowrap;"><?php echo date('d/m/Y H:i:s', strtotime($log['checked_at'])); ?></td>
                                <td><?php echo htmlspecialchars($log['ip_address'] ?? '-'); ?></td>
                                <td class="font-monospace"><?php echo htmlspecialchars($log['license_key_sent'] ?? '-'); ?></td>
                                <td><?php echo htmlspecialchars($log['domain_sent'] ?? '-'); ?></td>
                                <td>
                                     <?php
                                        $status_class = ($log['response_status'] === 'valid') ? 'badge bg-success' : 'badge bg-danger';
                                    ?>
                                    <span class="<?php echo $status_class; ?>"><?php echo htmlspecialchars($log['response_status']); ?></span>
                                </td>
                                <td><?php echo htmlspecialchars($log['response_reason'] ?? '-'); ?></td>
                                <td><?php echo htmlspecialchars($log['response_message'] ?? '-'); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-center text-muted">Henüz API çağrı logu bulunmamaktadır.</p>
            <?php endif; ?>
        </div>

        <!-- Sayfalama Navigasyonu -->
        <?php if ($total_pages > 1): ?>
            <nav aria-label="Page navigation">
                <ul class="pagination justify-content-center mt-4">
                    <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page - 1; ?>">Önceki</a>
                    </li>
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                    <?php endfor; ?>
                    <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page + 1; ?>">Sonraki</a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>

    </div>
</div>

<?php
// Footer'ı dahil et
require_once __DIR__ . '/includes/footer.php';
?>
