<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et (config.php oturumu başlatır)
require_once __DIR__ . '/../config/db_connect.php';

// Sadece POST isteklerini kabul et
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    // GET veya başka bir metotla gelindiyse login'e yönlendir
    header('Location: login.php');
    exit;
}

// Formdan gelen verileri al
$username = trim($_POST['username'] ?? '');
$password = $_POST['password'] ?? '';

// Girdileri kontrol et
if (empty($username) || empty($password)) {
    $_SESSION['login_error'] = "Kullanıcı adı ve şifre boş bırakılamaz.";
    header('Location: login.php');
    exit;
}

// Kullanıcıyı veritabanında ara (Prepared Statement kullanarak SQL Injection önlemi)
// Sadece aktif kullanıcıların giriş yapabilmesini sağla (is_active = 1)
$sql = "SELECT id, username, password_hash FROM users WHERE username = ? AND is_active = 1 LIMIT 1";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    error_log("Admin Auth - SQL prepare hatası: " . $conn->error);
    $_SESSION['login_error'] = "Sistemsel bir hata oluştu. Lütfen tekrar deneyin.";
    header('Location: login.php');
    exit;
}

$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    // Kullanıcı bulundu, şifreyi doğrula
    $user = $result->fetch_assoc();
    if (password_verify($password, $user['password_hash'])) {
        // Şifre doğru! Oturum bilgilerini ayarla.
        // Eski oturumu yenilemek (session fixation saldırılarını önlemek için)
        session_regenerate_id(true);

        $_SESSION['admin_user_id'] = $user['id'];
        $_SESSION['admin_username'] = $user['username'];
        // İleride gerekebilecek başka kullanıcı bilgilerini de oturuma ekleyebiliriz (örn: rol)

        // Başarılı giriş sonrası admin ana sayfasına yönlendir
        header("Location: index.php");
        exit;
    } else {
        // Şifre yanlış
        $_SESSION['login_error'] = "Kullanıcı adı veya şifre hatalı.";
        header('Location: login.php');
        exit;
    }
} else {
    // Kullanıcı bulunamadı veya aktif değil
    $_SESSION['login_error'] = "Kullanıcı adı veya şifre hatalı.";
    header('Location: login.php');
    exit;
}

// Statement ve bağlantıyı kapat (Normalde buraya ulaşılmaz)
$stmt->close();
$conn->close();
?>
