<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Oturum kontrolü
if (!isset($_SESSION['admin_user_id'])) {
    header("Location: login.php");
    exit;
}

// --- CSRF Token Doğrulama (GET isteği için) ---
// (delete_product.php'deki nota bakın)
if (!isset($_GET['token']) || !hash_equals($_SESSION['csrf_token'], $_GET['token'])) {
     $_SESSION['error_message'] = "Geçersiz güvenlik token'ı nedeniyle silme işlemi yapılamadı.";
     header("Location: licenses.php");
     exit;
}

// --- Lisans ID'sini Al ve Kontrol Et ---
if (!isset($_GET['id']) || !filter_var($_GET['id'], FILTER_VALIDATE_INT)) {
    $_SESSION['error_message'] = "Geçersiz lisans ID'si.";
    header("Location: licenses.php");
    exit;
}
$license_id = (int)$_GET['id'];

// --- CSRF Koruması (Önemli - Şimdilik Basit Tutuldu) ---
// Gerçek bir uygulamada, buraya mutlaka bir CSRF token doğrulaması eklenmelidir.
// (delete_product.php'deki nota bakın)

// --- Silme İşlemi ---
$sql = "DELETE FROM licenses WHERE id = ?";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    error_log("Delete License - SQL prepare hatası: " . $conn->error);
    $_SESSION['error_message'] = "Lisans silinirken bir SQL hatası oluştu.";
} else {
    $stmt->bind_param("i", $license_id);
    if ($stmt->execute()) {
        // Silme başarılı mı kontrol et (etkilenen satır sayısı)
        if ($stmt->affected_rows > 0) {
            $_SESSION['success_message'] = "Lisans (ID: {$license_id}) başarıyla silindi.";
        } else {
            // ID bulunamadı veya zaten silinmiş olabilir
            $_SESSION['error_message'] = "Silinecek lisans (ID: {$license_id}) bulunamadı veya zaten silinmiş.";
        }
    } else {
        error_log("Delete License - SQL execute hatası: " . $stmt->error);
        $_SESSION['error_message'] = "Lisans silinirken bir veritabanı hatası oluştu.";
    }
    $stmt->close();
}

$conn->close();

// Kullanıcıyı lisans listeleme sayfasına geri yönlendir
header("Location: licenses.php");
exit;

?>
