<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php'; // config.php oturumu başlatır

// Sayfa başlığını ayarla
$page_title = "Lisans Kontrol Aracı";

// Header'ı dahil et (Oturum kontrolünü ve CSRF token'ı yapar)
require_once __DIR__ . '/includes/header.php'; // $csrf_token burada tanımlanır

$license_key_input = '';
$domain_input = '';
$check_result_raw = null; // API'den gelen ham JSON
$check_result_interpreted = null; // Yorumlanmış sonuç
$perform_check = false; // Kontrolün yapılıp yapılmayacağını belirler

// GET parametrelerini kontrol et (licenses.php'den gelirse)
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['key']) && isset($_GET['domain'])) {
    $license_key_input = trim($_GET['key']);
    $domain_input = trim($_GET['domain']);
    // GET ile gelince CSRF kontrolü yapmayız, doğrudan kontrolü tetikle
    if (!empty($license_key_input) && !empty($domain_input)) {
        $perform_check = true;
    } else {
         $check_result_interpreted = ['status' => 'warning', 'message' => 'GET isteği ile gelen lisans anahtarı veya domain boş.'];
    }
}
// POST parametrelerini kontrol et
elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF Token Doğrulama
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $check_result_interpreted = ['status' => 'danger', 'message' => 'Geçersiz veya eksik güvenlik token\'ı.'];
        $license_key_input = trim($_POST['license_key'] ?? '');
        $domain_input = trim($_POST['domain'] ?? '');
    } else {
        // Token geçerli
        $license_key_input = trim($_POST['license_key'] ?? '');
        $domain_input = trim($_POST['domain'] ?? '');
        if (!empty($license_key_input) && !empty($domain_input)) {
             $perform_check = true;
        } else {
            $check_result_interpreted = ['status' => 'warning', 'message' => 'Lisans anahtarı ve domain alanları boş bırakılamaz.'];
        }
    }
}

// Kontrol gerçekleştirilecekse API'yi çağır
if ($perform_check) {
    // API endpoint URL'sini oluştur
    $base_url_for_api = rtrim(BASE_URL, '/');
    $api_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http")
             . "://{$_SERVER['HTTP_HOST']}" . $base_url_for_api . '/api/validate.php';

    // API'ye gönderilecek veriler
    $data = [
        'license_key' => $license_key_input,
        'domain' => $domain_input
    ];
    $url_with_params = $api_url . '?' . http_build_query($data);

    // API isteği yap
    $context_options = [
        'http' => ['method' => 'GET', 'timeout' => 15, 'ignore_errors' => true],
        // 'ssl' => [ 'verify_peer' => false, 'verify_peer_name' => false, ] // Yerel test için gerekebilir
    ];
    $context = stream_context_create($context_options);
    $response_json = @file_get_contents($url_with_params, false, $context);

    if ($response_json === false) {
        $check_result_interpreted = ['status' => 'danger', 'message' => 'API endpoint\'ine ulaşılamadı. URL\'yi ve sunucu durumunu kontrol edin: ' . htmlspecialchars($url_with_params)];
    } else {
        $check_result_raw = $response_json;
        $response_data = json_decode($response_json, true);

        if ($response_data === null || !isset($response_data['status'])) {
            $check_result_interpreted = ['status' => 'danger', 'message' => 'API\'den geçersiz JSON yanıtı alındı. API scriptini kontrol edin.'];
        } elseif ($response_data['status'] === 'valid') {
            $check_result_interpreted = ['status' => 'success', 'message' => 'Lisans GEÇERLİ. (' . htmlspecialchars($response_data['message'] ?? '') . ')'];
        } else { // invalid
            $reason = $response_data['reason'] ?? 'unknown';
            $message = $response_data['message'] ?? 'Bilinmeyen hata.';
            $check_result_interpreted = ['status' => 'danger', 'message' => 'Lisans GEÇERSİZ! Neden: ' . htmlspecialchars($message) . ' (Kod: ' . htmlspecialchars($reason) . ')'];
        }
    }
}

?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-patch-check-fill"></i> <?php echo htmlspecialchars($page_title); ?></h1>
</div>

<p>Bu araç, bir lisans anahtarının belirli bir domain için geçerli olup olmadığını `api/validate.php` endpoint'ini kullanarak test etmenizi sağlar.</p>

<div class="card shadow-sm mb-4">
    <div class="card-header">
        Kontrol Formu
    </div>
    <div class="card-body">
        <form action="license_check.php" method="post">
             <!-- CSRF Token -->
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="license_key" class="form-label">Lisans Anahtarı <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="license_key" name="license_key" value="<?php echo htmlspecialchars($license_key_input); ?>" required>
                </div>
                <div class="col-md-6">
                    <label for="domain" class="form-label">Domain <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="domain" name="domain" value="<?php echo htmlspecialchars($domain_input); ?>" placeholder="ornekdomain.com" required>
                    <div class="form-text">'www.' olmadan girin.</div>
                </div>
            </div>
            <button type="submit" class="btn btn-primary mt-3"><i class="bi bi-search"></i> Kontrol Et</button>
        </form>
    </div>
</div>

<?php if ($check_result_interpreted !== null): ?>
<div class="card shadow-sm">
    <div class="card-header">
        Kontrol Sonucu
    </div>
    <div class="card-body">
        <div class="alert alert-<?php echo $check_result_interpreted['status']; ?>" role="alert">
            <?php echo $check_result_interpreted['message']; ?>
        </div>

        <?php if ($check_result_raw !== null): ?>
            <h5>API Ham Yanıtı (JSON):</h5>
            <pre class="bg-light p-3 border rounded"><code><?php echo htmlspecialchars($check_result_raw); ?></code></pre>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>


<?php
// Footer'ı dahil et
require_once __DIR__ . '/includes/footer.php';
?>
