<?php
// Veritabanı bağlantısını ve yapılandırmayı dahil et
require_once __DIR__ . '/../config/db_connect.php';

// Sayfa başlığını ayarla
$page_title = "Ürün Yönetimi";

// Header'ı dahil et (Oturum kontrolünü yapar)
require_once __DIR__ . '/includes/header.php';

// Ürünleri veritabanından çek
$sql = "SELECT id, name, description, created_at FROM products ORDER BY created_at DESC";
$result = $conn->query($sql);

// Hata/Başarı mesajlarını oturumdan al (varsa)
$success_message = $_SESSION['success_message'] ?? null;
$error_message = $_SESSION['error_message'] ?? null;
unset($_SESSION['success_message'], $_SESSION['error_message']); // Gösterdikten sonra temizle

?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-box-seam-fill"></i> <?php echo htmlspecialchars($page_title); ?></h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="add_product.php" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> Yeni Ürün Ekle</a>
    </div>
</div>

<?php if ($success_message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo htmlspecialchars($success_message); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>
<?php if ($error_message): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo htmlspecialchars($error_message); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-header">
        Ürün Listesi
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <?php if ($result && $result->num_rows > 0): ?>
                <table class="table table-striped table-hover table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th scope="col">ID</th>
                            <th scope="col">Ürün Adı</th>
                            <th scope="col">Açıklama</th>
                            <th scope="col">Oluşturulma Tarihi</th>
                            <th scope="col" style="width: 120px;">İşlemler</th> <!-- Sabit genişlik -->
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo htmlspecialchars($row['name']); ?></td>
                                <td><?php echo nl2br(htmlspecialchars($row['description'] ?? '')); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($row['created_at'])); ?></td>
                                <td class="text-center">
                                    <a href="edit_product.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-primary" title="Düzenle"><i class="bi bi-pencil-fill"></i></a>
                                    <a href="delete_product.php?id=<?php echo $row['id']; ?>&token=<?php echo urlencode($csrf_token); ?>" class="btn btn-sm btn-outline-danger delete" title="Sil" data-confirm="Bu ürünü silmek istediğinizden emin misiniz? Bu ürüne ait tüm lisanslar da silinecektir!">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-center text-muted">Henüz ürün eklenmemiş.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
// Veritabanı bağlantısını kapat
$conn->close();

// Footer'ı dahil et
require_once __DIR__ . '/includes/footer.php';
?>
