<?php
// Yapılandırma dosyasını dahil et (config.php zaten oturumu başlatıyor)
// __DIR__ kullanarak dosyanın bulunduğu dizinden yola çıkmak daha güvenilirdir.
require_once __DIR__ . '/config.php';

// Veritabanı bağlantısı oluşturma (MySQLi)
// Hata gösterimini geçici olarak kapatalım, kendi hata yönetimimizi yapalım.
mysqli_report(MYSQLI_REPORT_OFF); // Önemli: Hataları kendimiz yakalayacağız.

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Bağlantı hatası kontrolü
if ($conn->connect_error) {
    // Gerçek uygulamada kullanıcıya detaylı hata göstermek yerine loglamak daha iyidir.
    error_log("Veritabanı Bağlantı Hatası: (" . $conn->connect_errno . ") " . $conn->connect_error);
    // Kullanıcıya genel bir hata mesajı gösterilebilir
    // Bu noktada script'i durdurmak genellikle en iyisidir.
    die("Veritabanı bağlantı hatası. Lütfen sistem yöneticisi ile iletişime geçin.");
}

// Karakter setini ayarla
if (!$conn->set_charset("utf8mb4")) {
    error_log("Karakter seti utf8mb4 ayarlanamadı: " . $conn->error);
    // Karakter seti hatası kritik olabilir, bu yüzden script'i durdurabiliriz.
    die("Veritabanı karakter seti hatası.");
}

// Bağlantı nesnesi ($conn) artık bu dosyayı include eden diğer scriptler tarafından kullanılabilir.
// Örneğin: require_once 'config/db_connect.php';
//          $result = $conn->query("SELECT * FROM users");

?>
