-- Veritabanı Adı: licensing_db

-- Kullanıcılar Tablosu (Yöneticiler)
CREATE TABLE IF NOT EXISTS `users` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(50) NOT NULL UNIQUE,
    `password_hash` VARCHAR(255) NOT NULL,
    `email` VARCHAR(100) NULL UNIQUE,
    `is_active` BOOLEAN NOT NULL DEFAULT 1,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Müşteriler Tablosu
CREATE TABLE IF NOT EXISTS `customers` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(100) NOT NULL,
    `email` VARCHAR(100) NULL UNIQUE,
    `company` VARCHAR(100) NULL,
    `phone` VARCHAR(20) NULL,
    `password_hash` VARCHAR(255) NULL,
    `is_active` BOOLEAN NOT NULL DEFAULT 1,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_customer_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Ürünler Tablosu
CREATE TABLE IF NOT EXISTS `products` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(100) NOT NULL,
    `description` TEXT NULL,
    `original_zip_path` VARCHAR(255) NULL,
    `critical_files` TEXT NULL, -- Tekrar aktif edildi
    `injection_placeholder` VARCHAR(100) NULL DEFAULT '// LISANS_KODU_BURADA',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Lisanslar Tablosu
CREATE TABLE IF NOT EXISTS `licenses` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `product_id` INT NOT NULL,
    `customer_id` INT NULL,
    `license_key` VARCHAR(60) NOT NULL UNIQUE,
    `domain` VARCHAR(255) NULL,
    `status` ENUM('active', 'inactive', 'expired') NOT NULL DEFAULT 'active',
    `expires_at` DATETIME NULL,
    `client_name` VARCHAR(100) NULL, -- Yedek olarak kalabilir
    `client_email` VARCHAR(100) NULL, -- Yedek olarak kalabilir
    `notes` TEXT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_license_key` (`license_key`),
    INDEX `idx_domain` (`domain`),
    INDEX `idx_customer_id` (`customer_id`),
    FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`customer_id`) REFERENCES `customers`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- API Çağrı Logları Tablosu
CREATE TABLE IF NOT EXISTS `api_logs` (
    `id` BIGINT AUTO_INCREMENT PRIMARY KEY,
    `license_key_sent` VARCHAR(60) NULL,
    `domain_sent` VARCHAR(255) NULL,
    `ip_address` VARCHAR(45) NULL,
    `user_agent` TEXT NULL,
    `response_status` VARCHAR(10) NOT NULL,
    `response_reason` VARCHAR(50) NULL,
    `response_message` VARCHAR(255) NULL,
    `checked_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_log_key` (`license_key_sent`),
    INDEX `idx_log_domain` (`domain_sent`),
    INDEX `idx_log_time` (`checked_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- Örnek Yönetici Kullanıcı Ekleme
INSERT INTO `users` (`username`, `password_hash`, `email`, `is_active`)
VALUES ('admin', '$2y$10$csJiLxfsEKY9/WMLbpP4Ie7PBjEoxJZQNdQIsTf33iJBpFCaMQ4KW', 'admin@example.com', 1)
ON DUPLICATE KEY UPDATE `username` = `username`;

-- Örnek Ürün Ekleme (critical_files tekrar eklendi)
INSERT INTO `products` (`name`, `description`, `original_zip_path`, `critical_files`, `injection_placeholder`)
VALUES ('Örnek Yazılım', 'Bu bir örnek yazılım ürünüdür.', NULL, 'index.php', '// LISANS_KODU_BURADA')
ON DUPLICATE KEY UPDATE `name` = `name`;

-- Örnek Müşteri Ekleme
INSERT INTO `customers` (`name`, `email`, `company`, `is_active`)
VALUES ('Test Müşteri', 'customer@example.com', 'Test A.Ş.', 1)
ON DUPLICATE KEY UPDATE `name` = `name`;


SELECT 'Database setup complete (including critical_files). Remember to change the default admin password hash!' AS `Status`;
