<?php
/**
 * Dijital Menü - Alerjenler Sayfası
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = __('admin.allergens', [], $adminLanguage);

// Ayarları al
$settings = getSetting();

// Alerjen işlemleri
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$allergenId = isset($_GET['id']) ? intval($_GET['id']) : 0;
$error = '';
$success = '';

// Alerjen silme işlemi
if (isset($_GET['delete']) && $allergenId > 0) {
    // Alerjenin kullanımda olup olmadığını kontrol et
    $result = $conn->query("SELECT COUNT(*) as count FROM item_allergens WHERE allergen_id = $allergenId");
    $row = $result->fetch_assoc();
    
    if ($row['count'] > 0) {
        $_SESSION['error_message'] = 'Bu alerjen menü öğelerinde kullanıldığı için silinemez.';
    } else {
        // Alerjeni sil
        $stmt = $conn->prepare("DELETE FROM allergens WHERE id = ?");
        $stmt->bind_param("i", $allergenId);
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = 'Alerjen başarıyla silindi.';
        } else {
            $_SESSION['error_message'] = 'Alerjen silinirken bir hata oluştu.';
        }
    }
    
    redirect('allergens.php');
}

// Alerjen ekleme/düzenleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Form verilerini al
    $name = isset($_POST['name']) ? clean($_POST['name']) : '';
    
    // İkon yükleme
    $icon = '';
    if (isset($_FILES['icon']) && $_FILES['icon']['error'] == 0) {
        $icon = uploadFile($_FILES['icon'], '../assets/img', ['png', 'jpg', 'jpeg', 'gif', 'svg']);
        
        if (!$icon) {
            $error = 'İkon yüklenirken bir hata oluştu.';
        }
    } elseif ($action === 'edit' && isset($_POST['current_icon']) && !empty($_POST['current_icon'])) {
        $icon = $_POST['current_icon'];
    }
    
    // Boş alan kontrolü
    if (empty($name)) {
        $error = 'Alerjen adı boş bırakılamaz.';
    } else {
        if ($action === 'add') {
            // Alerjen ekle
            $stmt = $conn->prepare("INSERT INTO allergens (name, icon) VALUES (?, ?)");
            $stmt->bind_param("ss", $name, $icon);
            
            if ($stmt->execute()) {
                $_SESSION['success_message'] = 'Alerjen başarıyla eklendi.';
                redirect('allergens.php');
            } else {
                $error = 'Alerjen eklenirken bir hata oluştu.';
            }
        } elseif ($action === 'edit' && $allergenId > 0) {
            // Alerjen güncelle
            $stmt = $conn->prepare("UPDATE allergens SET name = ?, icon = ? WHERE id = ?");
            $stmt->bind_param("ssi", $name, $icon, $allergenId);
            
            if ($stmt->execute()) {
                $_SESSION['success_message'] = 'Alerjen başarıyla güncellendi.';
                redirect('allergens.php');
            } else {
                $error = 'Alerjen güncellenirken bir hata oluştu.';
            }
        }
    }
}

// Alerjen bilgilerini al
$allergen = [];
if ($action === 'edit' && $allergenId > 0) {
    $stmt = $conn->prepare("SELECT * FROM allergens WHERE id = ?");
    $stmt->bind_param("i", $allergenId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $allergen = $result->fetch_assoc();
    } else {
        $_SESSION['error_message'] = 'Alerjen bulunamadı.';
        redirect('allergens.php');
    }
}

// Tüm alerjenleri al
$allergens = getAllergens();

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <?php if ($action === 'list'): ?>
                    <a href="allergens.php?action=add" class="btn btn-primary">
                        <i class="fas fa-plus-circle"></i> <?php echo __('admin.add_allergen', [], $adminLanguage); ?>
                    </a>
                    <?php else: ?>
                    <a href="allergens.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> <?php echo __('admin.go_back', [], $adminLanguage); ?>
                    </a>
                    <?php endif; ?>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <?php if ($action === 'list'): ?>
                    <!-- Alerjen Listesi -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="d-none">ID</th>
                                    <th><?php echo __('admin.image', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.name', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.actions', [], $adminLanguage); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($allergens)): ?>
                                <tr>
                                    <td colspan="4" class="text-center"><?php echo __('admin.no_allergens', [], $adminLanguage); ?></td>
                                </tr>
                                <?php else: ?>
                                <?php foreach ($allergens as $allergen): ?>
                                <tr>
                                    <td class="d-none"><?php echo $allergen['id']; ?></td>
                                    <td>
                                        <?php if (!empty($allergen['icon'])): ?>
                                        <img src="../assets/img/<?php echo $allergen['icon']; ?>" alt="<?php echo $allergen['name']; ?>" width="30" height="30">
                                        <?php else: ?>
                                        <div class="bg-light rounded d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                            <i class="fas fa-image text-muted"></i>
                                        </div>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $allergen['name']; ?></td>
                                    <td>
                                        <a href="allergens.php?action=edit&id=<?php echo $allergen['id']; ?>" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="allergens.php?delete=1&id=<?php echo $allergen['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('<?php echo __('admin.confirm_delete', [], $adminLanguage); ?>');">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <!-- Alerjen Formu -->
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF'] . '?action=' . $action . ($allergenId ? '&id=' . $allergenId : '')); ?>" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label"><?php echo __('admin.name', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" value="<?php echo $allergen['name'] ?? ''; ?>" required>
                                </div>

                                <?php if (isset($allergen['id']) && $allergen['id'] > 0): ?>
                                <div class="mb-3">
                                    <label class="form-label"><?php echo __('admin.translations', [], $adminLanguage); ?></label>
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i> <?php echo __('admin.allergen_translations', [], $adminLanguage); ?> <a href="translations.php?type=allergens&language=<?php echo getDefaultLanguage(); ?>" target="_blank"><?php echo __('admin.translations', [], $adminLanguage); ?></a>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="icon" class="form-label"><?php echo __('admin.image', [], $adminLanguage); ?></label>
                                    <?php if (isset($allergen['icon']) && !empty($allergen['icon'])): ?>
                                    <div class="mb-2">
                                        <img src="../assets/img/<?php echo $allergen['icon']; ?>" alt="<?php echo $allergen['name']; ?>" width="50" height="50">
                                        <input type="hidden" name="current_icon" value="<?php echo $allergen['icon']; ?>">
                                    </div>
                                    <?php endif; ?>
                                    <input type="file" class="form-control" id="icon" name="icon" accept="image/*">
                                    <small class="text-muted">Önerilen boyut: 50x50 piksel</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> <?php echo __('admin.save', [], $adminLanguage); ?>
                            </button>
                            <a href="allergens.php" class="btn btn-secondary">
                                <i class="fas fa-times"></i> <?php echo __('admin.cancel', [], $adminLanguage); ?>
                            </a>
                        </div>
                    </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
</body>
</html>
