<?php
/**
 * Dijital Menü - Kategoriler Sayfası
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = __('admin.category', [], $adminLanguage);

// Ayarları al
$settings = getSetting();

// Kategori işlemleri
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$categoryId = isset($_GET['id']) ? intval($_GET['id']) : 0;
$error = '';
$success = '';

// Sıralama işlemleri
if (isset($_GET['move'])) {
    $moveDirection = $_GET['move'];
    $moveId = isset($_GET['id']) ? intval($_GET['id']) : 0;
    
    if ($moveId > 0) {
        // Kategoriyi al
        $stmt = $conn->prepare("SELECT * FROM categories WHERE id = ?");
        $stmt->bind_param("i", $moveId);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $category = $result->fetch_assoc();
            $currentOrder = $category['sort_order'];
            
            if ($moveDirection === 'up') {
                // Bir üst sıradaki kategoriyi bul
                $stmt = $conn->prepare("SELECT * FROM categories WHERE sort_order < ? ORDER BY sort_order DESC LIMIT 1");
                $stmt->bind_param("i", $currentOrder);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows === 1) {
                    $swapCategory = $result->fetch_assoc();
                    
                    // Sıraları değiştir
                    $stmt = $conn->prepare("UPDATE categories SET sort_order = ? WHERE id = ?");
                    $stmt->bind_param("ii", $swapCategory['sort_order'], $moveId);
                    $stmt->execute();
                    
                    $stmt = $conn->prepare("UPDATE categories SET sort_order = ? WHERE id = ?");
                    $stmt->bind_param("ii", $currentOrder, $swapCategory['id']);
                    $stmt->execute();
                    
                    $_SESSION['success_message'] = 'Kategori sırası güncellendi.';
                }
            } elseif ($moveDirection === 'down') {
                // Bir alt sıradaki kategoriyi bul
                $stmt = $conn->prepare("SELECT * FROM categories WHERE sort_order > ? ORDER BY sort_order ASC LIMIT 1");
                $stmt->bind_param("i", $currentOrder);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows === 1) {
                    $swapCategory = $result->fetch_assoc();
                    
                    // Sıraları değiştir
                    $stmt = $conn->prepare("UPDATE categories SET sort_order = ? WHERE id = ?");
                    $stmt->bind_param("ii", $swapCategory['sort_order'], $moveId);
                    $stmt->execute();
                    
                    $stmt = $conn->prepare("UPDATE categories SET sort_order = ? WHERE id = ?");
                    $stmt->bind_param("ii", $currentOrder, $swapCategory['id']);
                    $stmt->execute();
                    
                    $_SESSION['success_message'] = 'Kategori sırası güncellendi.';
                }
            }
        }
    }
    
    redirect('categories.php');
}

// Kategori silme işlemi
if (isset($_GET['delete']) && $categoryId > 0) {
    // Kategorinin kullanımda olup olmadığını kontrol et
    $result = $conn->query("SELECT COUNT(*) as count FROM items WHERE category_id = $categoryId");
    $row = $result->fetch_assoc();
    
    if ($row['count'] > 0) {
        $_SESSION['error_message'] = 'Bu kategori menü öğelerinde kullanıldığı için silinemez.';
    } else {
        // Kategoriyi sil
        $stmt = $conn->prepare("DELETE FROM categories WHERE id = ?");
        $stmt->bind_param("i", $categoryId);
        
        if ($stmt->execute()) {
            // Kategori başarıyla silindi
            
            $_SESSION['success_message'] = 'Kategori başarıyla silindi.';
        } else {
            $_SESSION['error_message'] = 'Kategori silinirken bir hata oluştu.';
        }
    }
    
    redirect('categories.php');
}

// Kategori ekleme/düzenleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Form verilerini al
    $name = isset($_POST['name']) ? clean($_POST['name']) : '';
    $description = isset($_POST['description']) ? clean($_POST['description']) : '';
    $sortOrder = isset($_POST['sort_order']) ? intval($_POST['sort_order']) : 0;
    $status = isset($_POST['status']) ? 1 : 0;
    
    // Resim yükleme
    $image = '';
    
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $image = uploadFile($_FILES['image'], '../assets/img', ['png', 'jpg', 'jpeg', 'gif', 'svg']);
        
        if (!$image) {
            $error = 'Resim yüklenirken bir hata oluştu.';
        }
    } elseif ($action === 'edit' && isset($_POST['current_image']) && !empty($_POST['current_image'])) {
        $image = $_POST['current_image'];
    }
    
    // Boş alan kontrolü
    if (empty($name)) {
        $error = 'Kategori adı boş bırakılamaz.';
    } else {
        if ($action === 'add') {
            // Kategori ekle
            $stmt = $conn->prepare("INSERT INTO categories (name, description, image, sort_order, status) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("sssis", $name, $description, $image, $sortOrder, $status);
            
            if ($stmt->execute()) {
                // Kategori başarıyla eklendi
                
                $_SESSION['success_message'] = 'Kategori başarıyla eklendi.';
                redirect('categories.php');
            } else {
                $error = 'Kategori eklenirken bir hata oluştu.';
            }
        } elseif ($action === 'edit' && $categoryId > 0) {
            // Kategori güncelle
            $stmt = $conn->prepare("UPDATE categories SET name = ?, description = ?, image = ?, sort_order = ?, status = ? WHERE id = ?");
            $stmt->bind_param("sssisi", $name, $description, $image, $sortOrder, $status, $categoryId);
            
            if ($stmt->execute()) {
                // Kategori başarıyla güncellendi
                
                $_SESSION['success_message'] = 'Kategori başarıyla güncellendi.';
                redirect('categories.php');
            } else {
                $error = 'Kategori güncellenirken bir hata oluştu.';
            }
        }
    }
}

// Kategori bilgilerini al
$category = [];
if ($action === 'edit' && $categoryId > 0) {
    $stmt = $conn->prepare("SELECT * FROM categories WHERE id = ?");
    $stmt->bind_param("i", $categoryId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $category = $result->fetch_assoc();
    } else {
        $_SESSION['error_message'] = 'Kategori bulunamadı.';
        redirect('categories.php');
    }
}

// Arama ve filtreleme
$search = isset($_GET['search']) ? clean($_GET['search']) : '';
$statusFilter = isset($_GET['status']) ? $_GET['status'] : '';

// Kategorileri al
$sql = "SELECT * FROM categories";
$conditions = [];

// Arama filtresi
if (!empty($search)) {
    $conditions[] = "(LOWER(name) LIKE LOWER('%$search%') OR LOWER(description) LIKE LOWER('%$search%'))";
}

// Durum filtresi
if ($statusFilter !== '') {
    $conditions[] = "status = " . intval($statusFilter);
}

// Koşulları SQL sorgusuna ekle
if (!empty($conditions)) {
    $sql .= " WHERE " . implode(" AND ", $conditions);
}

// Sıralama
$sql .= " ORDER BY sort_order ASC, name ASC";

// Sorguyu çalıştır
$result = $conn->query($sql);
$categories = [];

while ($row = $result->fetch_assoc()) {
    $categories[] = $row;
}

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/admin.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <!-- Mobil menü kaldırıldı -->
    
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <?php if ($action === 'list'): ?>
                    <a href="categories.php?action=add" class="btn btn-primary">
                        <i class="fas fa-plus-circle"></i> <?php echo __('admin.add_category', [], $adminLanguage); ?>
                    </a>
                    <?php else: ?>
                    <a href="categories.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> <?php echo __('admin.go_back', [], $adminLanguage); ?>
                    </a>
                    <?php endif; ?>
                </div>
                
                <?php if ($action === 'list'): ?>
                <!-- Arama ve Filtre -->
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="get" action="categories.php" class="row g-3">
                            <div class="col-md-6">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="search" placeholder="<?php echo __('admin.search', [], $adminLanguage); ?>..." value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>">
                                    <button class="btn btn-outline-secondary" type="submit">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <select class="form-select" name="status">
                                    <option value=""><?php echo __('admin.all_status', [], $adminLanguage); ?></option>
                                    <option value="1" <?php echo (isset($_GET['status']) && $_GET['status'] == '1') ? 'selected' : ''; ?>><?php echo __('admin.active', [], $adminLanguage); ?></option>
                                    <option value="0" <?php echo (isset($_GET['status']) && $_GET['status'] == '0') ? 'selected' : ''; ?>><?php echo __('admin.inactive', [], $adminLanguage); ?></option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <a href="categories.php" class="btn btn-outline-secondary w-100">
                                    <i class="fas fa-redo"></i> <?php echo __('admin.reset', [], $adminLanguage); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <?php if ($action === 'list'): ?>
                    <!-- Kategori Listesi -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="d-none"><?php echo __('admin.id', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.image', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.name', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.description', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.sort_order', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.status', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.actions', [], $adminLanguage); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($categories)): ?>
                                <tr>
                                    <td colspan="7" class="text-center"><?php echo __('admin.no_categories', [], $adminLanguage); ?></td>
                                </tr>
                                <?php else: ?>
                                <?php foreach ($categories as $cat): ?>
                                <tr>
                                    <td class="d-none"><?php echo $cat['id']; ?></td>
                                    <td>
                                        <?php if (!empty($cat['image'])): ?>
                                        <img src="../assets/img/<?php echo $cat['image']; ?>" alt="<?php echo $cat['name']; ?>" width="50" height="50" style="object-fit: cover;">
                                        <?php else: ?>
                                        <div class="bg-light rounded d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                            <i class="fas fa-folder text-muted"></i>
                                        </div>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $cat['name']; ?></td>
                                    <td><?php echo $cat['description']; ?></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-2"><?php echo $cat['sort_order']; ?></span>
                                            <div class="btn-group-vertical btn-group-sm">
                                                <a href="categories.php?move=up&id=<?php echo $cat['id']; ?>" class="btn btn-outline-secondary btn-sm">
                                                    <i class="fas fa-arrow-up"></i>
                                                </a>
                                                <a href="categories.php?move=down&id=<?php echo $cat['id']; ?>" class="btn btn-outline-secondary btn-sm">
                                                    <i class="fas fa-arrow-down"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if ($cat['status'] == 1): ?>
                                        <span class="badge bg-success"><?php echo __('admin.active', [], $adminLanguage); ?></span>
                                        <?php else: ?>
                                        <span class="badge bg-danger"><?php echo __('admin.inactive', [], $adminLanguage); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="categories.php?action=edit&id=<?php echo $cat['id']; ?>" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="categories.php?delete=1&id=<?php echo $cat['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('<?php echo __('admin.confirm_delete', [], $adminLanguage); ?>');">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <!-- Kategori Formu -->
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF'] . '?action=' . $action . ($categoryId ? '&id=' . $categoryId : '')); ?>" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label"><?php echo __('admin.name', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" value="<?php echo $category['name'] ?? ''; ?>" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="description" class="form-label"><?php echo __('admin.description', [], $adminLanguage); ?></label>
                                    <textarea class="form-control" id="description" name="description" rows="3"><?php echo $category['description'] ?? ''; ?></textarea>
                                </div>

                                <?php if (isset($category['id']) && $category['id'] > 0): ?>
                                <div class="mb-3">
                                    <label class="form-label"><?php echo __('admin.translations', [], $adminLanguage); ?></label>
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i> <?php echo __('admin.category_translations', [], $adminLanguage); ?> <a href="translations.php?type=categories&language_id=<?php echo getDefaultLanguage(); ?>" target="_blank"><?php echo __('admin.translations', [], $adminLanguage); ?></a>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="image" class="form-label"><?php echo __('admin.image', [], $adminLanguage); ?></label>
                                    <?php if (isset($category['image']) && !empty($category['image'])): ?>
                                    <div class="mb-2 text-center">
                                        <img src="../assets/img/<?php echo $category['image']; ?>" alt="<?php echo $category['name']; ?>" class="img-thumbnail" style="max-height: 150px;">
                                        <input type="hidden" name="current_image" value="<?php echo $category['image']; ?>">
                                    </div>
                                    <?php endif; ?>
                                    <input type="file" class="form-control" id="image" name="image" accept="image/*">
                                </div>
                                
                                <div class="mb-3">
                                    <label for="sort_order" class="form-label"><?php echo __('admin.sort_order', [], $adminLanguage); ?></label>
                                    <input type="number" class="form-control" id="sort_order" name="sort_order" value="<?php echo $category['sort_order'] ?? 0; ?>" min="0">
                                </div>
                                
                                <div class="mb-3 form-check">
                                    <input type="checkbox" class="form-check-input" id="status" name="status" <?php echo (isset($category['status']) && $category['status'] == 1) ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="status"><?php echo __('admin.active', [], $adminLanguage); ?></label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> <?php echo __('admin.save', [], $adminLanguage); ?>
                            </button>
                            <a href="categories.php" class="btn btn-secondary">
                                <i class="fas fa-times"></i> <?php echo __('admin.cancel', [], $adminLanguage); ?>
                            </a>
                        </div>
                    </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
    <script src="../assets/js/admin.js"></script>
</body>
</html>
