<?php
/**
 * Dijital Menü - Admin Panel Ana Sayfa
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = __('admin.dashboard', [], $adminLanguage);

// Ayarları al
$settings = getSetting();

// İstatistikleri al
$stats = [
    'categories' => $conn->query("SELECT COUNT(*) as count FROM categories")->fetch_assoc()['count'],
    'items' => $conn->query("SELECT COUNT(*) as count FROM items")->fetch_assoc()['count'],
    'tables' => $conn->query("SELECT COUNT(*) as count FROM tables")->fetch_assoc()['count'],
    'waiter_calls' => $conn->query("SELECT COUNT(*) as count FROM waiter_calls WHERE status = 'pending'")->fetch_assoc()['count']
];

// Son eklenen menü öğeleri
$latestItems = [];
$result = $conn->query("SELECT i.*, c.name as category_name FROM items i JOIN categories c ON i.category_id = c.id ORDER BY i.id DESC LIMIT 5");
while ($row = $result->fetch_assoc()) {
    $latestItems[] = $row;
}

// Son garson çağrıları
$latestCalls = [];
$result = $conn->query("SELECT wc.*, t.name as table_name FROM waiter_calls wc JOIN tables t ON wc.table_id = t.id ORDER BY wc.id DESC LIMIT 5");
while ($row = $result->fetch_assoc()) {
    $latestCalls[] = $row;
}

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <div>
                        <a href="../index.php" target="_blank" class="btn btn-outline-primary">
                            <i class="fas fa-external-link-alt"></i> Menüyü Görüntüle
                        </a>
                    </div>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <!-- İstatistik Kartları -->
                <div class="row mb-4">
                    <div class="col-md-6 col-lg-3 mb-4">
                        <div class="dashboard-card bg-primary text-white p-4">
                            <div class="text-center">
                                <i class="fas fa-list dashboard-card-icon"></i>
                                <div class="dashboard-card-number"><?php echo $stats['categories']; ?></div>
                                <div class="h5"><?php echo __('admin.category', [], $adminLanguage); ?></div>
                            </div>
                            <div class="text-center mt-3">
                                <a href="categories.php" class="btn btn-light">
                                    <i class="fas fa-arrow-right"></i> <?php echo __('admin.manage', [], $adminLanguage); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 col-lg-3 mb-4">
                        <div class="dashboard-card bg-success text-white p-4">
                            <div class="text-center">
                                <i class="fas fa-utensils dashboard-card-icon"></i>
                                <div class="dashboard-card-number"><?php echo $stats['items']; ?></div>
                                <div class="h5"><?php echo __('admin.items', [], $adminLanguage); ?></div>
                            </div>
                            <div class="text-center mt-3">
                                <a href="items.php" class="btn btn-light">
                                    <i class="fas fa-arrow-right"></i> <?php echo __('admin.manage', [], $adminLanguage); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 col-lg-3 mb-4">
                        <div class="dashboard-card bg-info text-white p-4">
                            <div class="text-center">
                                <i class="fas fa-chair dashboard-card-icon"></i>
                                <div class="dashboard-card-number"><?php echo $stats['tables']; ?></div>
                                <div class="h5"><?php echo __('admin.tables', [], $adminLanguage); ?></div>
                            </div>
                            <div class="text-center mt-3">
                                <a href="tables.php" class="btn btn-light">
                                    <i class="fas fa-arrow-right"></i> <?php echo __('admin.manage', [], $adminLanguage); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 col-lg-3 mb-4">
                        <div class="dashboard-card bg-danger text-white p-4">
                            <div class="text-center">
                                <i class="fas fa-bell dashboard-card-icon"></i>
                                <div class="dashboard-card-number"><?php echo $stats['waiter_calls']; ?></div>
                                <div class="h5"><?php echo __('admin.waiter_calls', [], $adminLanguage); ?></div>
                            </div>
                            <div class="text-center mt-3">
                                <a href="waiter-calls.php" class="btn btn-light">
                                    <i class="fas fa-arrow-right"></i> <?php echo __('admin.manage', [], $adminLanguage); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Son Eklenen Menü Öğeleri ve Garson Çağrıları -->
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="admin-card h-100">
                            <h2 class="h5 mb-3"><?php echo __('admin.latest_items', [], $adminLanguage); ?></h2>
                            
                            <?php if (empty($latestItems)): ?>
                            <div class="alert alert-info"><?php echo __('admin.no_items', [], $adminLanguage); ?></div>
                            <?php else: ?>
                            <div class="list-group">
                                <?php foreach ($latestItems as $item): ?>
                                <a href="items.php?action=edit&id=<?php echo $item['id']; ?>" class="list-group-item list-group-item-action">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h5 class="mb-1"><?php echo $item['name']; ?></h5>
                                        <small><?php echo formatMoney($item['price']); ?></small>
                                    </div>
                                    <p class="mb-1"><?php echo $item['category_name']; ?></p>
                                    <small class="text-muted">
                                        <?php if (isset($item['is_special']) && $item['is_special']): ?>
                                        <span class="badge bg-danger"><?php echo __('admin.is_special', [], $adminLanguage); ?></span>
                                        <?php endif; ?>
                                        
                                        <?php if (isset($item['is_popular']) && $item['is_popular']): ?>
                                        <span class="badge bg-success"><?php echo __('admin.is_popular', [], $adminLanguage); ?></span>
                                        <?php endif; ?>
                                    </small>
                                </a>
                                <?php endforeach; ?>
                            </div>
                            <?php endif; ?>
                            
                            <div class="mt-3">
                                <a href="items.php?action=add" class="btn btn-primary">
                                    <i class="fas fa-plus-circle"></i> <?php echo __('admin.add_item', [], $adminLanguage); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <div class="admin-card h-100">
                            <h2 class="h5 mb-3"><?php echo __('admin.latest_calls', [], $adminLanguage); ?></h2>
                            
                            <?php if (empty($latestCalls)): ?>
                            <div class="alert alert-info"><?php echo __('admin.no_calls', [], $adminLanguage); ?></div>
                            <?php else: ?>
                            <div class="list-group">
                                <?php foreach ($latestCalls as $call): ?>
                                <div class="list-group-item <?php echo ($call['status'] === 'pending') ? 'list-group-item-danger' : 'list-group-item-success'; ?>">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h5 class="mb-1"><?php echo $call['table_name']; ?></h5>
                                        <small>
                                            <?php 
                                            $callTime = strtotime($call['created_at']);
                                            $now = time();
                                            $diff = $now - $callTime;
                                            
                                            if ($diff < 60) {
                                                echo __('admin.just_now', [], $adminLanguage);
                                            } elseif ($diff < 3600) {
                                                echo floor($diff / 60) . ' ' . __('admin.minutes_ago', [], $adminLanguage);
                                            } elseif ($diff < 86400) {
                                                echo floor($diff / 3600) . ' ' . __('admin.hours_ago', [], $adminLanguage);
                                            } else {
                                                echo date('d.m.Y H:i', $callTime);
                                            }
                                            ?>
                                        </small>
                                    </div>
                                    <p class="mb-1">
                                        <?php if ($call['status'] === 'pending'): ?>
                                        <span class="badge bg-danger"><?php echo __('admin.pending', [], $adminLanguage); ?></span>
                                        <?php else: ?>
                                        <span class="badge bg-success"><?php echo __('admin.completed', [], $adminLanguage); ?></span>
                                        <?php endif; ?>
                                    </p>
                                    
                                    <?php if ($call['status'] === 'pending'): ?>
                                    <div class="mt-2">
                                        <a href="waiter-calls.php?complete=1&id=<?php echo $call['id']; ?>" class="btn btn-sm btn-success">
                                            <i class="fas fa-check"></i> <?php echo __('admin.complete', [], $adminLanguage); ?>
                                        </a>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <?php endif; ?>
                            
                            <div class="mt-3">
                                <a href="waiter-calls.php" class="btn btn-primary">
                                    <i class="fas fa-bell"></i> <?php echo __('admin.view_all_calls', [], $adminLanguage); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Hızlı Erişim -->
                <div class="row">
                    <div class="col-12">
                        <div class="admin-card">
                            <h2 class="h5 mb-3"><?php echo __('admin.quick_access', [], $adminLanguage); ?></h2>
                            
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <a href="categories.php?action=add" class="btn btn-outline-primary w-100">
                                        <i class="fas fa-plus-circle"></i> <?php echo __('admin.add_category', [], $adminLanguage); ?>
                                    </a>
                                </div>
                                
                                <div class="col-md-4 mb-3">
                                    <a href="items.php?action=add" class="btn btn-outline-success w-100">
                                        <i class="fas fa-plus-circle"></i> <?php echo __('admin.add_item', [], $adminLanguage); ?>
                                    </a>
                                </div>
                                
                                <div class="col-md-4 mb-3">
                                    <a href="tables.php?action=add" class="btn btn-outline-info w-100">
                                        <i class="fas fa-plus-circle"></i> <?php echo __('admin.add_table', [], $adminLanguage); ?>
                                    </a>
                                </div>
                                
                                <div class="col-md-4 mb-3">
                                    <a href="settings.php" class="btn btn-outline-secondary w-100">
                                        <i class="fas fa-cog"></i> <?php echo __('admin.edit_settings', [], $adminLanguage); ?>
                                    </a>
                                </div>
                                
                                <div class="col-md-4 mb-3">
                                    <a href="users.php" class="btn btn-outline-dark w-100">
                                        <i class="fas fa-users"></i> <?php echo __('admin.manage_users', [], $adminLanguage); ?>
                                    </a>
                                </div>
                                
                                <div class="col-md-4 mb-3">
                                    <a href="../index.php" target="_blank" class="btn btn-outline-primary w-100">
                                        <i class="fas fa-external-link-alt"></i> <?php echo __('admin.view_menu', [], $adminLanguage); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
</body>
</html>
