<?php
/**
 * Dijital Menü - Admin Panel Giriş Sayfası
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Giriş yapılmışsa yönlendir
redirectIfLoggedIn('index.php');

// Varsayılan dili al
$defaultLanguage = getDefaultLanguage();

// Sayfa başlığı
$pageTitle = __('admin.login', [], $defaultLanguage);

// Ayarları al
$settings = getSetting();

// Giriş işlemi
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = isset($_POST['username']) ? clean($_POST['username']) : '';
    $password = isset($_POST['password']) ? $_POST['password'] : '';
    $remember = isset($_POST['remember']) ? true : false;
    
    if (empty($username) || empty($password)) {
        $error = __('admin.username_password_required', [], $defaultLanguage);
    } else {
        $user = login($username, $password);
        
        if ($user) {
            // Başarılı giriş
            if ($remember) {
                // Hatırla beni işlemi
                $token = bin2hex(random_bytes(32));
                $expires = time() + (86400 * 30); // 30 gün
                
                $stmt = $conn->prepare("UPDATE users SET remember_token = ?, remember_expires = ? WHERE id = ?");
                $stmt->bind_param("ssi", $token, date('Y-m-d H:i:s', $expires), $user['id']);
                $stmt->execute();
                
                setcookie('remember_token', $token, $expires, '/');
            }
            
            // Admin paneli dilini ayarla
            if (isset($settings['admin_language'])) {
                changeAdminLanguage($settings['admin_language']);
            }
            
            // Kullanıcı rolüne göre yönlendirme
            if ($user['role'] === 'waiter') {
                redirect('waiter-calls.php');
            } else {
                redirect('index.php');
            }
        } else {
            // Başarısız giriş
            $error = __('admin.invalid_credentials', [], $defaultLanguage);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
        
        body {
            background-color: var(--light-gray);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        
        .login-container {
            max-width: 400px;
            width: 100%;
            padding: 20px;
        }
        
        .login-card {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        
        .login-header {
            background-color: var(--primary-color);
            color: white;
            padding: 20px;
            text-align: center;
        }
        
        .login-body {
            padding: 30px;
        }
        
        .login-footer {
            background-color: var(--light-gray);
            padding: 15px;
            text-align: center;
            border-top: 1px solid #eee;
        }
        
        .login-logo {
            max-height: 60px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <?php if (!empty($settings['logo'])): ?>
                <img src="../assets/img/<?php echo $settings['logo']; ?>" alt="<?php echo $settings['site_title'] ?? 'Dijital Menü'; ?>" class="login-logo">
                <?php endif; ?>
                <h1 class="h4 mb-0"><?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></h1>
                <p class="mb-0"><?php echo __('admin.admin_panel', [], $defaultLanguage); ?></p>
            </div>
            
            <div class="login-body">
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
                    <div class="mb-3">
                        <label for="username" class="form-label"><?php echo __('admin.username', [], $defaultLanguage); ?></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                            <input type="text" class="form-control" id="username" name="username" placeholder="<?php echo __('admin.enter_username', [], $defaultLanguage); ?>" required>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="password" class="form-label"><?php echo __('admin.password', [], $defaultLanguage); ?></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-lock"></i></span>
                            <input type="password" class="form-control" id="password" name="password" placeholder="<?php echo __('admin.enter_password', [], $defaultLanguage); ?>" required>
                        </div>
                    </div>
                    
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="remember" name="remember">
                        <label class="form-check-label" for="remember"><?php echo __('admin.remember_me', [], $defaultLanguage); ?></label>
                    </div>
                    
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-sign-in-alt"></i> <?php echo __('admin.login', [], $defaultLanguage); ?>
                        </button>
                    </div>
                </form>
                
                <div class="mt-3 text-center">
                    <a href="../index.php" class="text-decoration-none">
                        <i class="fas fa-arrow-left"></i> <?php echo __('admin.back_to_site', [], $defaultLanguage); ?>
                    </a>
                </div>
            </div>
            
            <div class="login-footer">
                <p class="mb-0"><?php echo $settings['footer_text'] ?? '© 2025 Dijital Menü. Tüm hakları saklıdır.'; ?></p>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
</body>
</html>
