<?php
/**
 * Dijital Menü - Puanlama Yönetimi
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = 'Puanlama Yönetimi';

// Ayarları al
$settings = getSetting();

// Puanlama işlemleri
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$ratingId = isset($_GET['id']) ? intval($_GET['id']) : 0;
$error = '';
$success = '';

// Puanlama durumunu güncelleme
if (isset($_GET['approve']) && $ratingId > 0) {
    if (updateRatingStatus($ratingId, 'approved', $_SESSION['user_id'])) {
        $_SESSION['success_message'] = 'Puanlama başarıyla onaylandı.';
    } else {
        $_SESSION['error_message'] = 'Puanlama onaylanırken bir hata oluştu.';
    }
    redirect('ratings.php');
}

// Puanlama reddetme
if (isset($_GET['reject']) && $ratingId > 0) {
    if (updateRatingStatus($ratingId, 'rejected', $_SESSION['user_id'])) {
        $_SESSION['success_message'] = 'Puanlama başarıyla reddedildi.';
    } else {
        $_SESSION['error_message'] = 'Puanlama reddedilirken bir hata oluştu.';
    }
    redirect('ratings.php');
}

// Puanlama silme
if (isset($_GET['delete']) && $ratingId > 0) {
    if (deleteRating($ratingId)) {
        $_SESSION['success_message'] = 'Puanlama başarıyla silindi.';
    } else {
        $_SESSION['error_message'] = 'Puanlama silinirken bir hata oluştu.';
    }
    redirect('ratings.php');
}

// Toplu silme işlemi
if (isset($_POST['bulk_action']) && $_POST['bulk_action'] === 'delete' && !empty($_POST['selected_ids'])) {
    $selectedIds = explode(',', $_POST['selected_ids']);
    $successCount = 0;
    $errorCount = 0;
    
    foreach ($selectedIds as $id) {
        $id = intval($id);
        if ($id > 0) {
            if (deleteRating($id)) {
                $successCount++;
            } else {
                $errorCount++;
            }
        }
    }
    
    if ($successCount > 0) {
        $_SESSION['success_message'] = $successCount . ' puanlama başarıyla silindi.';
    }
    
    if ($errorCount > 0) {
        $_SESSION['error_message'] = $errorCount . ' puanlama silinirken hata oluştu.';
    }
    
    redirect('ratings.php' . (isset($_GET['status']) ? '?status=' . $_GET['status'] : ''));
}

// Puanlama filtreleme
$statusFilter = isset($_GET['status']) ? clean($_GET['status']) : null;
$searchFilter = isset($_GET['search']) ? clean($_GET['search']) : null;
$ratingFilter = isset($_GET['rating']) ? intval($_GET['rating']) : null;
$categoryFilter = isset($_GET['category']) ? intval($_GET['category']) : null;
$startDateFilter = isset($_GET['start_date']) ? clean($_GET['start_date']) : null;
$endDateFilter = isset($_GET['end_date']) ? clean($_GET['end_date']) : null;

// Kategorileri al
$categories = getCategories();

// Tüm puanlamaları al
$ratings = getAllRatings($statusFilter, $searchFilter, $ratingFilter, $categoryFilter, $startDateFilter, $endDateFilter);

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/ratings.css" rel="stylesheet">
    <link href="../assets/css/admin-mobile.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
        
        .rating-status-pending {
            background-color: #ffc107;
            color: #212529;
        }
        
        .rating-status-approved {
            background-color: #28a745;
            color: #fff;
        }
        
        .rating-status-rejected {
            background-color: #dc3545;
            color: #fff;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <!-- Filtreler -->
                    <div class="mb-4">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="btn-group" role="group" aria-label="Puanlama Filtreleri">
                                    <a href="ratings.php<?php echo isset($_GET['search']) || isset($_GET['rating']) || isset($_GET['category']) ? '?' . http_build_query(array_filter([
                                        'search' => $searchFilter,
                                        'rating' => $ratingFilter,
                                        'category' => $categoryFilter
                                    ])) : ''; ?>" class="btn <?php echo $statusFilter === null ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                        Tümü
                                    </a>
                                    <a href="ratings.php?status=pending<?php echo isset($_GET['search']) || isset($_GET['rating']) || isset($_GET['category']) ? '&' . http_build_query(array_filter([
                                        'search' => $searchFilter,
                                        'rating' => $ratingFilter,
                                        'category' => $categoryFilter
                                    ])) : ''; ?>" class="btn <?php echo $statusFilter === 'pending' ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                        Bekleyen
                                    </a>
                                    <a href="ratings.php?status=approved<?php echo isset($_GET['search']) || isset($_GET['rating']) || isset($_GET['category']) ? '&' . http_build_query(array_filter([
                                        'search' => $searchFilter,
                                        'rating' => $ratingFilter,
                                        'category' => $categoryFilter
                                    ])) : ''; ?>" class="btn <?php echo $statusFilter === 'approved' ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                        Onaylanan
                                    </a>
                                    <a href="ratings.php?status=rejected<?php echo isset($_GET['search']) || isset($_GET['rating']) || isset($_GET['category']) ? '&' . http_build_query(array_filter([
                                        'search' => $searchFilter,
                                        'rating' => $ratingFilter,
                                        'category' => $categoryFilter
                                    ])) : ''; ?>" class="btn <?php echo $statusFilter === 'rejected' ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                        Reddedilen
                                    </a>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <form method="get" action="ratings.php" class="d-flex">
                                    <?php if (isset($_GET['status'])): ?>
                                    <input type="hidden" name="status" value="<?php echo htmlspecialchars($_GET['status']); ?>">
                                    <?php endif; ?>
                                    <input type="text" name="search" class="form-control" placeholder="Ürün veya kategori ara..." value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>">
                                    <button type="submit" class="btn btn-primary ms-2">
                                        <i class="fas fa-search"></i>
                                    </button>
                                    <?php if (isset($_GET['search']) || isset($_GET['rating']) || isset($_GET['category'])): ?>
                                    <a href="ratings.php<?php echo isset($_GET['status']) ? '?status=' . $_GET['status'] : ''; ?>" class="btn btn-outline-secondary ms-2" title="Filtreyi Temizle">
                                        <i class="fas fa-times"></i>
                                    </a>
                                    <?php endif; ?>
                                </form>
                            </div>
                        </div>
                        
                        <!-- Gelişmiş Filtreler -->
                        <div class="row">
                            <div class="col-md-12">
                                <form method="get" action="ratings.php" class="row g-3">
                                    <?php if (isset($_GET['status'])): ?>
                                    <input type="hidden" name="status" value="<?php echo htmlspecialchars($_GET['status']); ?>">
                                    <?php endif; ?>
                                    
                                    <?php if (isset($_GET['search'])): ?>
                                    <input type="hidden" name="search" value="<?php echo htmlspecialchars($_GET['search']); ?>">
                                    <?php endif; ?>
                                    
                                    <div class="col-md-3">
                                        <label for="ratingFilter" class="form-label">Puan Filtresi</label>
                                        <select class="form-select" id="ratingFilter" name="rating">
                                            <option value="">Tüm Puanlar</option>
                                            <option value="5" <?php echo $ratingFilter === 5 ? 'selected' : ''; ?>>5 Yıldız</option>
                                            <option value="4" <?php echo $ratingFilter === 4 ? 'selected' : ''; ?>>4 Yıldız</option>
                                            <option value="3" <?php echo $ratingFilter === 3 ? 'selected' : ''; ?>>3 Yıldız</option>
                                            <option value="2" <?php echo $ratingFilter === 2 ? 'selected' : ''; ?>>2 Yıldız</option>
                                            <option value="1" <?php echo $ratingFilter === 1 ? 'selected' : ''; ?>>1 Yıldız</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3">
                                        <label for="categoryFilter" class="form-label">Kategori Filtresi</label>
                                        <select class="form-select" id="categoryFilter" name="category">
                                            <option value="">Tüm Kategoriler</option>
                                            <?php foreach ($categories as $category): ?>
                                            <option value="<?php echo $category['id']; ?>" <?php echo $categoryFilter === $category['id'] ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($category['name']); ?>
                                            </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3">
                                        <label for="dateRangeFilter" class="form-label">Tarih Aralığı</label>
                                        <div class="input-group">
                                            <input type="date" class="form-control" id="startDateFilter" name="start_date" value="<?php echo $startDateFilter; ?>" placeholder="Başlangıç">
                                            <span class="input-group-text">-</span>
                                            <input type="date" class="form-control" id="endDateFilter" name="end_date" value="<?php echo $endDateFilter; ?>" placeholder="Bitiş">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 d-flex align-items-end">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-filter"></i> Filtrele
                                        </button>
                                        <?php if (isset($_GET['rating']) || isset($_GET['category']) || isset($_GET['start_date']) || isset($_GET['end_date'])): ?>
                                        <a href="ratings.php<?php echo isset($_GET['status']) ? '?status=' . $_GET['status'] : ''; ?><?php echo isset($_GET['search']) ? (isset($_GET['status']) ? '&' : '?') . 'search=' . urlencode($_GET['search']) : ''; ?>" class="btn btn-outline-secondary ms-2">
                                            <i class="fas fa-times"></i> Filtreleri Temizle
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Toplu İşlem Butonları -->
                    <div class="mb-3">
                        <form id="bulkActionForm" method="post" action="">
                            <div class="d-flex gap-2">
                                <button type="button" id="bulkDeleteBtn" class="btn btn-danger" disabled>
                                    <i class="fas fa-trash"></i> Seçilenleri Sil
                                </button>
                                <input type="hidden" name="bulk_action" id="bulkAction" value="">
                                <input type="hidden" name="selected_ids" id="selectedIds" value="">
                            </div>
                        </form>
                    </div>
                    
                    <!-- Puanlama Listesi -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="selectAll">
                                            <label class="form-check-label" for="selectAll"></label>
                                        </div>
                                    </th>
                                    <th>ID</th>
                                    <th>Ürün</th>
                                    <th>Kategori</th>
                                    <th>Kullanıcı</th>
                                    <th>Puan</th>
                                    <th>Yorum</th>
                                    <th>Durum</th>
                                    <th>Tarih</th>
                                    <th>İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($ratings)): ?>
                                <tr>
                                    <td colspan="9" class="text-center">Puanlama bulunamadı.</td>
                                </tr>
                                <?php else: ?>
                                <?php foreach ($ratings as $rating): ?>
                                <tr>
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input rating-checkbox" type="checkbox" value="<?php echo $rating['id']; ?>" id="rating-<?php echo $rating['id']; ?>">
                                            <label class="form-check-label" for="rating-<?php echo $rating['id']; ?>"></label>
                                        </div>
                                    </td>
                                    <td><?php echo $rating['id']; ?></td>
                                    <td><?php echo $rating['item_name']; ?></td>
                                    <td><?php echo $rating['category_name']; ?></td>
                                    <td><?php echo htmlspecialchars($rating['user_name']); ?></td>
                                    <td>
                                        <div class="star-rating">
                                            <?php echo generateStarRating($rating['rating']); ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if (!empty($rating['comment'])): ?>
                                        <button type="button" class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#commentModal-<?php echo $rating['id']; ?>">
                                            <i class="fas fa-comment"></i> Yorumu Gör
                                        </button>
                                        
                                        <!-- Yorum Modal -->
                                        <div class="modal fade" id="commentModal-<?php echo $rating['id']; ?>" tabindex="-1" aria-labelledby="commentModalLabel-<?php echo $rating['id']; ?>" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="commentModalLabel-<?php echo $rating['id']; ?>">Kullanıcı Yorumu</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p><strong>Ürün:</strong> <?php echo $rating['item_name']; ?></p>
                                                        <p><strong>Kullanıcı:</strong> <?php echo htmlspecialchars($rating['user_name']); ?></p>
                                                        <p><strong>Puan:</strong> <?php echo $rating['rating']; ?>/5</p>
                                                        <p><strong>Yorum:</strong></p>
                                                        <div class="p-3 bg-light rounded">
                                                            <?php echo nl2br(htmlspecialchars($rating['comment'])); ?>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php else: ?>
                                        <span class="text-muted">Yorum yok</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($rating['status'] === 'pending'): ?>
                                        <span class="badge rating-status-pending">Bekliyor</span>
                                        <?php elseif ($rating['status'] === 'approved'): ?>
                                        <span class="badge rating-status-approved">Onaylandı</span>
                                        <?php elseif ($rating['status'] === 'rejected'): ?>
                                        <span class="badge rating-status-rejected">Reddedildi</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo formatDate($rating['created_at']); ?></td>
                                    <td>
                                        <?php if ($rating['status'] === 'pending'): ?>
                                        <a href="ratings.php?approve=1&id=<?php echo $rating['id']; ?>" class="btn btn-sm btn-success" title="Onayla">
                                            <i class="fas fa-check"></i>
                                        </a>
                                        <a href="ratings.php?reject=1&id=<?php echo $rating['id']; ?>" class="btn btn-sm btn-danger" title="Reddet">
                                            <i class="fas fa-times"></i>
                                        </a>
                                        <?php endif; ?>
                                        <a href="ratings.php?delete=1&id=<?php echo $rating['id']; ?>" class="btn btn-sm btn-danger" title="Sil" onclick="return confirm('Bu puanlamayı silmek istediğinize emin misiniz?');">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
    
    <!-- Overlay Arka Planı -->
    <div class="overlay-background" id="overlayBackground"></div>
    
    <!-- Toplu İşlem JS -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Mobil menü toggle
            const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
            const adminSidebar = document.getElementById('adminSidebar');
            const overlayBackground = document.getElementById('overlayBackground');
            
            // Mobil menü toggle
            if (mobileMenuToggle && adminSidebar && overlayBackground) {
                // Menü açma
                mobileMenuToggle.addEventListener('click', function() {
                    adminSidebar.classList.toggle('show');
                    overlayBackground.classList.toggle('active');
                    document.body.style.overflow = adminSidebar.classList.contains('show') ? 'hidden' : '';
                });
                
                // Overlay'a tıklayınca menüyü kapat
                overlayBackground.addEventListener('click', function() {
                    adminSidebar.classList.remove('show');
                    overlayBackground.classList.remove('active');
                    document.body.style.overflow = '';
                });
            }
            
            // Toplu işlem fonksiyonları
            const selectAllCheckbox = document.getElementById('selectAll');
            const ratingCheckboxes = document.querySelectorAll('.rating-checkbox');
            const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');
            const bulkActionForm = document.getElementById('bulkActionForm');
            const bulkAction = document.getElementById('bulkAction');
            const selectedIds = document.getElementById('selectedIds');
            
            // Tümünü Seç checkbox'ı
            if (selectAllCheckbox) {
                selectAllCheckbox.addEventListener('change', function() {
                    const isChecked = this.checked;
                    
                    // Tüm checkbox'ları seç/kaldır
                    ratingCheckboxes.forEach(checkbox => {
                        checkbox.checked = isChecked;
                    });
                    
                    // Buton durumunu güncelle
                    updateBulkButtonState();
                });
            }
            
            // Her bir checkbox için olay dinleyicisi
            ratingCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    // Tümünü Seç checkbox'ını güncelle
                    updateSelectAllCheckbox();
                    
                    // Buton durumunu güncelle
                    updateBulkButtonState();
                });
            });
            
            // Toplu Silme butonu
            if (bulkDeleteBtn) {
                bulkDeleteBtn.addEventListener('click', function() {
                    if (confirm('Seçilen puanlamaları silmek istediğinize emin misiniz?')) {
                        // Seçilen ID'leri al
                        const ids = [];
                        ratingCheckboxes.forEach(checkbox => {
                            if (checkbox.checked) {
                                ids.push(checkbox.value);
                            }
                        });
                        
                        // Form değerlerini ayarla
                        bulkAction.value = 'delete';
                        selectedIds.value = ids.join(',');
                        
                        // Formu gönder
                        bulkActionForm.submit();
                    }
                });
            }
            
            // Tümünü Seç checkbox'ını güncelle
            function updateSelectAllCheckbox() {
                if (selectAllCheckbox) {
                    const checkedCount = document.querySelectorAll('.rating-checkbox:checked').length;
                    const totalCount = ratingCheckboxes.length;
                    
                    selectAllCheckbox.checked = checkedCount === totalCount && totalCount > 0;
                    selectAllCheckbox.indeterminate = checkedCount > 0 && checkedCount < totalCount;
                }
            }
            
            // Buton durumunu güncelle
            function updateBulkButtonState() {
                if (bulkDeleteBtn) {
                    const checkedCount = document.querySelectorAll('.rating-checkbox:checked').length;
                    bulkDeleteBtn.disabled = checkedCount === 0;
                }
            }
        });
    </script>
</body>
</html>
