<?php
// LISANS_KODU_BURADA
/**
 * Dijital Menü - Ayarlar Sayfası
 */

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/language.php';

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = 'Ayarlar';

// Ayarları al
$settings = getSetting();

// Hata ve başarı mesajları
$error = '';
$success = '';

// Ayarları kaydet
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Form verilerini al
    $siteTitle = isset($_POST['site_title']) ? clean($_POST['site_title']) : '';
    $siteUrl = isset($_POST['site_url']) ? clean($_POST['site_url']) : (isset($settings['site_url']) ? $settings['site_url'] : 'http://localhost/digiv4');
    $primaryColor = isset($_POST['primary_color']) ? clean($_POST['primary_color']) : '#4361ee';
    $secondaryColor = isset($_POST['secondary_color']) ? clean($_POST['secondary_color']) : '#3a0ca3';
    $textColor = isset($_POST['text_color']) ? clean($_POST['text_color']) : '#2b2d42';
    $backgroundColor = isset($_POST['background_color']) ? clean($_POST['background_color']) : '#f8f9fa';
    $currencySymbol = isset($_POST['currency_symbol']) ? clean($_POST['currency_symbol']) : '₺';
    $currencyPosition = isset($_POST['currency_position']) ? clean($_POST['currency_position']) : 'after';
    $footerText = isset($_POST['footer_text']) ? clean($_POST['footer_text']) : '© 2025 Dijital Menü. Tüm hakları saklıdır.';
    $enableWaiterCall = isset($_POST['enable_waiter_call']) ? 1 : 0;
    $enableAllergens = isset($_POST['enable_allergens']) ? 1 : 0;
    $enableMultilingual = isset($_POST['enable_multilingual']) ? 1 : 0;
    $enableItemFeatures = isset($_POST['enable_item_features']) ? 1 : 0;
    $enableRatings = isset($_POST['enable_ratings']) ? 1 : 0;
    $enableSlider = isset($_POST['enable_slider']) ? 1 : 0;
    $enableFeedback = isset($_POST['enable_feedback']) ? 1 : 0;
    $requireApproval = isset($_POST['require_approval']) ? 1 : 0;
    $minRating = isset($_POST['min_rating']) ? intval($_POST['min_rating']) : 1;
    $maxRating = isset($_POST['max_rating']) ? intval($_POST['max_rating']) : 5;
    $defaultLanguage = isset($_POST['default_language']) ? clean($_POST['default_language']) : 'tr';
    $adminLanguage = isset($_POST['admin_language']) ? clean($_POST['admin_language']) : 'tr';
    
    // Happy Hour ayarlarını al
    $happyHourEnabled = isset($_POST['happy_hour_enabled']) ? 1 : 0;
    $happyHourStartTime = isset($_POST['happy_hour_start_time']) ? clean($_POST['happy_hour_start_time']) : '17:00';
    $happyHourEndTime = isset($_POST['happy_hour_end_time']) ? clean($_POST['happy_hour_end_time']) : '19:00';
    $happyHourTitle = isset($_POST['happy_hour_title']) ? clean($_POST['happy_hour_title']) : 'Happy Hour!';
    $happyHourMessage = isset($_POST['happy_hour_message']) ? clean($_POST['happy_hour_message']) : 'Tüm içeceklerde %20 indirim!';
    $happyHourBgColor = isset($_POST['happy_hour_bg_color']) ? clean($_POST['happy_hour_bg_color']) : '#FF9800';
    $happyHourTextColor = isset($_POST['happy_hour_text_color']) ? clean($_POST['happy_hour_text_color']) : '#FFFFFF';
    $happyHourDays = isset($_POST['happy_hour_days']) ? clean($_POST['happy_hour_days']) : '[1,2,3,4,5]';
    
    // Logo yükleme
    $logo = '';
    if (isset($_FILES['logo']) && $_FILES['logo']['error'] == 0) {
        $logo = uploadFile($_FILES['logo'], '../assets/img', ['png', 'jpg', 'jpeg', 'gif', 'svg']);
        
        if (!$logo) {
            $error = 'Logo yüklenirken bir hata oluştu.';
        }
    } elseif (isset($settings['logo']) && !empty($settings['logo'])) {
        $logo = $settings['logo'];
    }
    
    // Favicon yükleme
    $favicon = '';
    if (isset($_FILES['favicon']) && $_FILES['favicon']['error'] == 0) {
        $favicon = uploadFile($_FILES['favicon'], '../assets/img', ['png', 'jpg', 'jpeg', 'gif', 'ico']);
        
        if (!$favicon) {
            $error = 'Favicon yüklenirken bir hata oluştu.';
        }
    } elseif (isset($settings['favicon']) && !empty($settings['favicon'])) {
        $favicon = $settings['favicon'];
    }
    
    // Sidebar ayarlarını al
    $contactInfo = isset($_POST['contact_info']) ? clean($_POST['contact_info']) : '';
    $wifiName = isset($_POST['wifi_name']) ? clean($_POST['wifi_name']) : 'Restaurant WiFi';
    $wifiPassword = isset($_POST['wifi_password']) ? clean($_POST['wifi_password']) : '';
    $googleMapsReviewLink = isset($_POST['google_maps_review_link']) ? clean($_POST['google_maps_review_link']) : '';
    
    // Sosyal medya ayarlarını al
    $socialFacebook = isset($_POST['social_facebook']) ? clean($_POST['social_facebook']) : '';
    $socialInstagram = isset($_POST['social_instagram']) ? clean($_POST['social_instagram']) : '';
    $socialTwitter = isset($_POST['social_twitter']) ? clean($_POST['social_twitter']) : '';
    $socialYoutube = isset($_POST['social_youtube']) ? clean($_POST['social_youtube']) : '';
    
    // Sosyal medya JSON'ı oluştur
    $socialMedia = json_encode([
        'facebook' => $socialFacebook,
        'instagram' => $socialInstagram,
        'twitter' => $socialTwitter,
        'youtube' => $socialYoutube
    ]);
    
    // Form verilerinden ek renk ayarlarını al
    $headerColor = isset($_POST['header_color']) ? clean($_POST['header_color']) : '#333333';
    $headerBgColor = isset($_POST['header_bg_color']) ? clean($_POST['header_bg_color']) : '#3490dc';
    $headerTextColor = isset($_POST['header_text_color']) ? clean($_POST['header_text_color']) : '#ffffff';
    $categoryCardBg = isset($_POST['category_card_bg']) ? clean($_POST['category_card_bg']) : '#f8f8f8';
    $categoryCardText = isset($_POST['category_card_text']) ? clean($_POST['category_card_text']) : '#ffffff';
    $categoryCardGradientStart = isset($_POST['category_card_gradient_start']) ? clean($_POST['category_card_gradient_start']) : 'rgba(0, 0, 0, 0.7)';
    $categoryColor1 = isset($_POST['category_color_1']) ? clean($_POST['category_color_1']) : '#F8D7A8';
    $categoryColor2 = isset($_POST['category_color_2']) ? clean($_POST['category_color_2']) : '#F8C8A8';
    $categoryColor3 = isset($_POST['category_color_3']) ? clean($_POST['category_color_3']) : '#A8F8D7';
    $categoryColor4 = isset($_POST['category_color_4']) ? clean($_POST['category_color_4']) : '#A8C8F8';
    $categoryColor5 = isset($_POST['category_color_5']) ? clean($_POST['category_color_5']) : '#D7A8F8';
    $bottomMenuColor = isset($_POST['bottom_menu_color']) ? clean($_POST['bottom_menu_color']) : '#ffffff';
    $bottomMenuItemColor = isset($_POST['bottom_menu_item_color']) ? clean($_POST['bottom_menu_item_color']) : '#6c757d';
    $menuItemBgColor = isset($_POST['menu_item_bg_color']) ? clean($_POST['menu_item_bg_color']) : '#ffffff';
    $menuItemTitleColor = isset($_POST['menu_item_title_color']) ? clean($_POST['menu_item_title_color']) : '#2b2d42';
    $menuItemDescColor = isset($_POST['menu_item_desc_color']) ? clean($_POST['menu_item_desc_color']) : '#6c757d';
    $menuItemBorderColor = isset($_POST['menu_item_border_color']) ? clean($_POST['menu_item_border_color']) : '#e9ecef';
    $menuItemPriceColor = isset($_POST['menu_item_price_color']) ? clean($_POST['menu_item_price_color']) : '#4361ee';
    $menuItemPriceBg = isset($_POST['menu_item_price_bg']) ? clean($_POST['menu_item_price_bg']) : 'rgba(67, 97, 238, 0.1)';
    
    // İletişim bilgileri renkleri
    $contactHeaderBgColor = isset($_POST['contact_header_bg_color']) ? clean($_POST['contact_header_bg_color']) : '#3490dc';
    $contactHeaderTextColor = isset($_POST['contact_header_text_color']) ? clean($_POST['contact_header_text_color']) : '#ffffff';
    $contactBgColor = isset($_POST['contact_bg_color']) ? clean($_POST['contact_bg_color']) : '#ffffff';
    $contactTextColor = isset($_POST['contact_text_color']) ? clean($_POST['contact_text_color']) : '#333333';
    
    // Buton renkleri
    $buttonPrimaryHoverBg = isset($_POST['button_primary_hover_bg']) ? clean($_POST['button_primary_hover_bg']) : '#3a0ca3';
    $buttonPrimaryHoverBorder = isset($_POST['button_primary_hover_border']) ? clean($_POST['button_primary_hover_border']) : '#3a0ca3';
    $buttonSuccessHoverBg = isset($_POST['button_success_hover_bg']) ? clean($_POST['button_success_hover_bg']) : '#40916c';
    $buttonSuccessHoverBorder = isset($_POST['button_success_hover_border']) ? clean($_POST['button_success_hover_border']) : '#40916c';
    
    // Overlay renkleri
    $overlayBgColor = isset($_POST['overlay_bg_color']) ? clean($_POST['overlay_bg_color']) : 'rgba(43, 45, 66, 0.8)';
    $overlayContentBg = isset($_POST['overlay_content_bg']) ? clean($_POST['overlay_content_bg']) : '#ffffff';
    $overlayContentShadow = isset($_POST['overlay_content_shadow']) ? clean($_POST['overlay_content_shadow']) : 'rgba(0, 0, 0, 0.2)';
    
    // Sosyal medya bağlantı renkleri
    $socialLinkBg = isset($_POST['social_link_bg']) ? clean($_POST['social_link_bg']) : '#f8f9fa';
    $socialLinkHoverBg = isset($_POST['social_link_hover_bg']) ? clean($_POST['social_link_hover_bg']) : '#4361ee';
    $socialLinkHoverText = isset($_POST['social_link_hover_text']) ? clean($_POST['social_link_hover_text']) : '#ffffff';
    
    // Site açıklaması
    $siteDescription = isset($_POST['site_description']) ? clean($_POST['site_description']) : 'Restoran Dijital Menü Sistemi';
    
    // Temel renkler - Modern görünüm için güncellenmiş renkler
    $lightGray = isset($_POST['light_gray']) ? clean($_POST['light_gray']) : '#e9ecef';
    $darkGray = isset($_POST['dark_gray']) ? clean($_POST['dark_gray']) : '#343a40';
    $dangerColor = isset($_POST['danger_color']) ? clean($_POST['danger_color']) : '#e63946';
    $warningColor = isset($_POST['warning_color']) ? clean($_POST['warning_color']) : '#ffb703';
    $infoColor = isset($_POST['info_color']) ? clean($_POST['info_color']) : '#4cc9f0';
    $successColor = isset($_POST['success_color']) ? clean($_POST['success_color']) : '#52b788';
    
    // Ayarları güncelle
    $settingsToUpdate = [
        'site_title' => $siteTitle,
        'site_url' => $siteUrl,
        'site_description' => $siteDescription,
        'primary_color' => $primaryColor,
        'secondary_color' => $secondaryColor,
        'text_color' => $textColor,
        'background_color' => $backgroundColor,
        'light_gray' => $lightGray,
        'dark_gray' => $darkGray,
        'danger_color' => $dangerColor,
        'warning_color' => $warningColor,
        'info_color' => $infoColor,
        'success_color' => $successColor,
        'header_color' => $headerColor,
        'header_bg_color' => $headerBgColor,
        'header_text_color' => $headerTextColor,
        'category_card_bg' => $categoryCardBg,
        'category_card_text' => $categoryCardText,
        'category_card_gradient_start' => $categoryCardGradientStart,
        'category_color_1' => $categoryColor1,
        'category_color_2' => $categoryColor2,
        'category_color_3' => $categoryColor3,
        'category_color_4' => $categoryColor4,
        'category_color_5' => $categoryColor5,
        'bottom_menu_color' => $bottomMenuColor,
        'bottom_menu_item_color' => $bottomMenuItemColor,
        'menu_item_bg_color' => $menuItemBgColor,
        'menu_item_title_color' => $menuItemTitleColor,
        'menu_item_desc_color' => $menuItemDescColor,
        'menu_item_border_color' => $menuItemBorderColor,
        'menu_item_price_color' => $menuItemPriceColor,
        'menu_item_price_bg' => $menuItemPriceBg,
        'contact_header_bg_color' => $contactHeaderBgColor,
        'contact_header_text_color' => $contactHeaderTextColor,
        'contact_bg_color' => $contactBgColor,
        'contact_text_color' => $contactTextColor,
        'button_primary_hover_bg' => $buttonPrimaryHoverBg,
        'button_primary_hover_border' => $buttonPrimaryHoverBorder,
        'button_success_hover_bg' => $buttonSuccessHoverBg,
        'button_success_hover_border' => $buttonSuccessHoverBorder,
        'overlay_bg_color' => $overlayBgColor,
        'overlay_content_bg' => $overlayContentBg,
        'overlay_content_shadow' => $overlayContentShadow,
        'social_link_bg' => $socialLinkBg,
        'social_link_hover_bg' => $socialLinkHoverBg,
        'social_link_hover_text' => $socialLinkHoverText,
        'currency_symbol' => $currencySymbol,
        'currency_position' => $currencyPosition,
        'footer_text' => $footerText,
        'enable_waiter_call' => $enableWaiterCall,
        'enable_allergens' => $enableAllergens,
        'enable_multilingual' => $enableMultilingual,
        'enable_item_features' => $enableItemFeatures,
        'enable_ratings' => $enableRatings,
        'enable_slider' => $enableSlider,
        'enable_feedback' => $enableFeedback,
        'require_approval' => $requireApproval,
        'min_rating' => $minRating,
        'max_rating' => $maxRating,
        'default_language' => $defaultLanguage,
        'admin_language' => $adminLanguage,
        'contact_info' => $contactInfo,
        'wifi_name' => $wifiName,
        'wifi_password' => $wifiPassword,
        'google_maps_review_link' => $googleMapsReviewLink,
        'social_media' => $socialMedia,
        'happy_hour_enabled' => $happyHourEnabled,
        'happy_hour_start_time' => $happyHourStartTime,
        'happy_hour_end_time' => $happyHourEndTime,
        'happy_hour_title' => $happyHourTitle,
        'happy_hour_message' => $happyHourMessage,
        'happy_hour_bg_color' => $happyHourBgColor,
        'happy_hour_text_color' => $happyHourTextColor,
        'happy_hour_days' => $happyHourDays
    ];
    
    if (!empty($logo)) {
        $settingsToUpdate['logo'] = $logo;
    }
    
    if (!empty($favicon)) {
        $settingsToUpdate['favicon'] = $favicon;
    }
    
    $updateSuccess = true;
    
    foreach ($settingsToUpdate as $key => $value) {
        // Ayar var mı kontrol et
        $stmt = $conn->prepare("SELECT COUNT(*) as count FROM settings WHERE setting_key = ?");
        $stmt->bind_param("s", $key);
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();
        
        if ($row['count'] > 0) {
            // Ayarı güncelle
            $stmt = $conn->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
            $stmt->bind_param("ss", $value, $key);
        } else {
            // Ayarı ekle
            $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?)");
            $stmt->bind_param("ss", $key, $value);
        }
        
        if (!$stmt->execute()) {
            $updateSuccess = false;
            break;
        }
    }
    
    if ($updateSuccess) {
        $success = 'Ayarlar başarıyla güncellendi.';
        
        // Varsayılan dili güncelle
        $conn->query("UPDATE languages SET is_default = 0");
        $stmt = $conn->prepare("UPDATE languages SET is_default = 1 WHERE code = ?");
        $stmt->bind_param("s", $defaultLanguage);
        $stmt->execute();
        
        // Admin paneli dilini değiştir
        if (isset($_POST['admin_language'])) {
            changeAdminLanguage($_POST['admin_language']);
        }
        
        // Ayarları yeniden al
        $settings = getSetting();
    } else {
        $error = 'Ayarlar güncellenirken bir hata oluştu.';
    }
}

// Dilleri al
$languages = getAvailableLanguages();

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Aktif kullanıcı bilgilerini al
$user = getUser($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
            --light-gray: <?php echo $settings['light_gray'] ?? '#f8f9fa'; ?>;
            --dark-gray: <?php echo $settings['dark_gray'] ?? '#343a40'; ?>;
            --danger-color: <?php echo $settings['danger_color'] ?? '#e3342f'; ?>;
            --warning-color: <?php echo $settings['warning_color'] ?? '#ffed4a'; ?>;
            --info-color: <?php echo $settings['info_color'] ?? '#6cb2eb'; ?>;
            --success-color: <?php echo $settings['success_color'] ?? '#51d88a'; ?>;
            --header-color: <?php echo $settings['header_color'] ?? '#333333'; ?>;
            --header-bg-color: <?php echo $settings['header_bg_color'] ?? '#333333'; ?>;
            --header-text-color: <?php echo $settings['header_text_color'] ?? '#ffffff'; ?>;
            --category-card-bg: <?php echo $settings['category_card_bg'] ?? '#f8f8f8'; ?>;
            --category-card-text: <?php echo $settings['category_card_text'] ?? '#ffffff'; ?>;
            --category-card-gradient-start: <?php echo $settings['category_card_gradient_start'] ?? 'rgba(0, 0, 0, 0.7)'; ?>;
            --category-card-gradient-end: rgba(0, 0, 0, 0);
            --category-color-1: <?php echo $settings['category_color_1'] ?? '#F8D7A8'; ?>;
            --category-color-2: <?php echo $settings['category_color_2'] ?? '#F8C8A8'; ?>;
            --category-color-3: <?php echo $settings['category_color_3'] ?? '#A8F8D7'; ?>;
            --category-color-4: <?php echo $settings['category_color_4'] ?? '#A8C8F8'; ?>;
            --category-color-5: <?php echo $settings['category_color_5'] ?? '#D7A8F8'; ?>;
            --bottom-menu-color: <?php echo $settings['bottom_menu_color'] ?? '#ffffff'; ?>;
            --bottom-menu-item-color: <?php echo $settings['bottom_menu_item_color'] ?? '#777777'; ?>;
            --menu-item-bg-color: <?php echo $settings['menu_item_bg_color'] ?? '#ffffff'; ?>;
            --menu-item-title-color: <?php echo $settings['menu_item_title_color'] ?? '#333333'; ?>;
            --menu-item-desc-color: <?php echo $settings['menu_item_desc_color'] ?? '#666666'; ?>;
            --menu-item-border-color: <?php echo $settings['menu_item_border_color'] ?? '#f0f0f0'; ?>;
            --menu-item-price-color: <?php echo $settings['menu_item_price_color'] ?? '#3490dc'; ?>;
            --menu-item-price-bg: <?php echo $settings['menu_item_price_bg'] ?? 'rgba(52, 144, 220, 0.1)'; ?>;
            --button-primary-hover-bg: <?php echo $settings['button_primary_hover_bg'] ?? '#2779bd'; ?>;
            --button-primary-hover-border: <?php echo $settings['button_primary_hover_border'] ?? '#2779bd'; ?>;
            --button-success-hover-bg: <?php echo $settings['button_success_hover_bg'] ?? '#2d995b'; ?>;
            --button-success-hover-border: <?php echo $settings['button_success_hover_border'] ?? '#2d995b'; ?>;
            --overlay-bg-color: <?php echo $settings['overlay_bg_color'] ?? 'rgba(0, 0, 0, 0.7)'; ?>;
            --overlay-content-bg: <?php echo $settings['overlay_content_bg'] ?? 'white'; ?>;
            --overlay-content-shadow: <?php echo $settings['overlay_content_shadow'] ?? 'rgba(0, 0, 0, 0.2)'; ?>;
            --social-link-bg: <?php echo $settings['social_link_bg'] ?? '#f5f5f5'; ?>;
            --social-link-hover-bg: <?php echo $settings['social_link_hover_bg'] ?? '#3490dc'; ?>;
            --social-link-hover-text: <?php echo $settings['social_link_hover_text'] ?? 'white'; ?>;
            --card-border-radius: <?php echo $settings['card_border_radius'] ?? '20px'; ?>;
            --card-shadow: <?php echo $settings['card_shadow'] ?? '0 10px 30px rgba(0, 0, 0, 0.15)'; ?>;
            --contact-header-bg-color: <?php echo $settings['contact_header_bg_color'] ?? '#3490dc'; ?>;
            --contact-header-text-color: <?php echo $settings['contact_header_text_color'] ?? '#ffffff'; ?>;
            --contact-bg-color: <?php echo $settings['contact_bg_color'] ?? '#ffffff'; ?>;
            --contact-text-color: <?php echo $settings['contact_text_color'] ?? '#333333'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo __('admin.settings', [], $adminLanguage); ?></h1>
                    <a href="../index.php" target="_blank" class="btn btn-outline-primary">
                        <i class="fas fa-external-link-alt"></i> <?php echo __('admin.view_menu', [], $adminLanguage); ?>
                    </a>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" enctype="multipart/form-data">
                        <ul class="nav nav-tabs mb-4" id="settingsTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="general-tab" data-bs-toggle="tab" data-bs-target="#general" type="button" role="tab" aria-controls="general" aria-selected="true">
                                    <i class="fas fa-cog"></i> <?php echo __('admin.general', [], $adminLanguage); ?>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="appearance-tab" data-bs-toggle="tab" data-bs-target="#appearance" type="button" role="tab" aria-controls="appearance" aria-selected="false">
                                    <i class="fas fa-palette"></i> Görünüm
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="currency-tab" data-bs-toggle="tab" data-bs-target="#currency" type="button" role="tab" aria-controls="currency" aria-selected="false">
                                    <i class="fas fa-money-bill"></i> <?php echo __('admin.currency_symbol', [], $adminLanguage); ?>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="sidebar-tab" data-bs-toggle="tab" data-bs-target="#sidebar" type="button" role="tab" aria-controls="sidebar" aria-selected="false">
                                    <i class="fas fa-bars"></i> <?php echo __('admin.contact', [], $adminLanguage); ?>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="features-tab" data-bs-toggle="tab" data-bs-target="#features" type="button" role="tab" aria-controls="features" aria-selected="false">
                                    <i class="fas fa-puzzle-piece"></i> <?php echo __('admin.features', [], $adminLanguage); ?>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="happy-hour-tab" data-bs-toggle="tab" data-bs-target="#happy-hour" type="button" role="tab" aria-controls="happy-hour" aria-selected="false">
                                    <i class="fas fa-glass-cheers"></i> Happy Hour
                                </button>
                            </li>
                            <!-- Özellikler sekmesi -->
                        </ul>
                        
                        <div class="tab-content" id="settingsTabsContent">
                            <!-- Sekme içerikleri -->
                            <?php include 'settings-tabs/general.php'; ?>
                            <?php include 'settings-tabs/appearance.php'; ?>
                            <?php include 'settings-tabs/currency.php'; ?>
                            <?php include 'settings-tabs/sidebar.php'; ?>
                            <?php include 'settings-tabs/features.php'; ?>
                            <?php include 'settings-tabs/happy_hour.php'; ?>
                            <!-- Diğer ayarlar sekmesi kaldırıldı, içeriği genel ayarlar sekmesine taşındı -->
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> <?php echo __('admin.save', [], $adminLanguage); ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
    
    <!-- Görünüm Ayarları JS -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Para birimi önizleme
            function updatePricePreview() {
                const symbol = document.getElementById('currency_symbol').value;
                const position = document.getElementById('currency_position').value;
                
                let priceText = '';
                if (position === 'before') {
                    priceText = symbol + '100,00';
                } else {
                    priceText = '100,00 ' + symbol;
                }
                
                document.getElementById('price-preview').textContent = priceText;
            }
            
            document.getElementById('currency_symbol').addEventListener('input', updatePricePreview);
            document.getElementById('currency_position').addEventListener('change', updatePricePreview);
            
            // Sayfa yüklendiğinde önizlemeleri güncelle
            updatePricePreview();
        });
    </script>
</body>
</html>
