<?php
/**
 * Dijital Menü - Kullanıcı Düzenleme Sayfası
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Veritabanı bağlantısını dahil et
require_once '../config/database.php';

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/functions.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Kullanıcı ID'sini al
$userId = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Kullanıcı ID'si yoksa listeye yönlendir
if ($userId <= 0) {
    $_SESSION['error_message'] = 'Geçersiz kullanıcı ID\'si.';
    redirect('users.php');
}

// Sayfa başlığı
$pageTitle = __('admin.edit_user', [], $adminLanguage);

// Ayarları al
$settings = getSetting();

// Hata ve başarı mesajları
$error = '';
$success = '';

// Kullanıcı bilgilerini al
$user = [];

// Doğrudan SQL sorgusu ile kullanıcı bilgilerini al
$sql = "SELECT * FROM users WHERE id = " . $userId;
$result = $conn->query($sql);

if ($result && $result->num_rows === 1) {
    $user = $result->fetch_assoc();
} else {
    $_SESSION['error_message'] = 'Kullanıcı bulunamadı.';
    redirect('users.php');
}

// Kullanıcı düzenleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Form verilerini al
    $username = isset($_POST['username']) ? clean($_POST['username']) : '';
    $email = isset($_POST['email']) ? clean($_POST['email']) : '';
    $name = isset($_POST['name']) ? clean($_POST['name']) : '';
    $role = isset($_POST['role']) ? clean($_POST['role']) : 'waiter';
    $status = isset($_POST['status']) ? 1 : 0;
    $password = isset($_POST['password']) ? $_POST['password'] : '';
    $confirmPassword = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';
    
    // POST ile gelen kullanıcı ID'sini kontrol et
    $postUserId = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
    if ($postUserId > 0) {
        $userId = $postUserId;
    }
    
    // Boş alan kontrolü
    if (empty($username) || empty($email) || empty($name)) {
        $error = __('admin.empty_fields_error', [], $adminLanguage);
    } elseif (!empty($password) && $password !== $confirmPassword) {
        $error = __('admin.passwords_not_match', [], $adminLanguage);
    } else {
        // E-posta formatı kontrolü
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = __('admin.invalid_email', [], $adminLanguage);
        } else {
            // Kullanıcı adı ve e-posta benzersizlik kontrolü
            $checkSql = "SELECT id FROM users WHERE (username = '" . $conn->real_escape_string($username) . "' OR email = '" . $conn->real_escape_string($email) . "') AND id != " . $userId;
            $checkResult = $conn->query($checkSql);
            
            if ($checkResult && $checkResult->num_rows > 0) {
                $error = __('admin.username_email_exists', [], $adminLanguage);
            } else {
                // Kullanıcı güncelle
                if (!empty($password)) {
                    // Şifreyi hashle
                    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
                    
                    // Şifre ile güncelle
                    $updateSql = "UPDATE users SET 
                        username = '" . $conn->real_escape_string($username) . "', 
                        password = '" . $conn->real_escape_string($hashedPassword) . "', 
                        email = '" . $conn->real_escape_string($email) . "', 
                        name = '" . $conn->real_escape_string($name) . "', 
                        role = '" . $conn->real_escape_string($role) . "', 
                        status = " . $status . " 
                        WHERE id = " . $userId;
                } else {
                    // Şifre olmadan güncelle
                    $updateSql = "UPDATE users SET 
                        username = '" . $conn->real_escape_string($username) . "', 
                        email = '" . $conn->real_escape_string($email) . "', 
                        name = '" . $conn->real_escape_string($name) . "', 
                        role = '" . $conn->real_escape_string($role) . "', 
                        status = " . $status . " 
                        WHERE id = " . $userId;
                }
                
                if ($conn->query($updateSql)) {
                    $_SESSION['success_message'] = __('admin.user_updated', [], $adminLanguage);
                    redirect('users.php');
                } else {
                    $error = __('admin.user_update_error', [], $adminLanguage) . ' ' . $conn->error;
                }
            }
        }
    }
    
    // Hata durumunda kullanıcı bilgilerini tekrar yükle
    if (!empty($error)) {
        $sql = "SELECT * FROM users WHERE id = " . $userId;
        $result = $conn->query($sql);
        
        if ($result && $result->num_rows === 1) {
            $user = $result->fetch_assoc();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/admin.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <a href="users.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> <?php echo __('admin.go_back', [], $adminLanguage); ?>
                    </a>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $error; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($success)): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $success; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <!-- Kullanıcı Formu -->
                    <form method="post" action="user-edit.php?id=<?php echo $userId; ?>">
                        <!-- Gizli alanlar -->
                        <input type="hidden" name="user_id" value="<?php echo $userId; ?>">
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="username" class="form-label"><?php echo __('admin.username', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="username" name="username" value="<?php echo htmlspecialchars($user['username']); ?>" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="email" class="form-label"><?php echo __('admin.email', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="name" class="form-label"><?php echo __('admin.name', [], $adminLanguage); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" value="<?php echo htmlspecialchars($user['name']); ?>" required>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label"><?php echo __('admin.password', [], $adminLanguage); ?></label>
                                    <input type="password" class="form-control" id="password" name="password">
                                    <small class="form-text text-muted"><?php echo __('admin.leave_empty_password', [], $adminLanguage); ?></small>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="confirm_password" class="form-label"><?php echo __('admin.confirm_password', [], $adminLanguage); ?></label>
                                    <input type="password" class="form-control" id="confirm_password" name="confirm_password">
                                </div>
                                
                                <div class="mb-3">
                                    <label for="role" class="form-label"><?php echo __('admin.role', [], $adminLanguage); ?></label>
                                    <select class="form-select" id="role" name="role">
                                        <option value="admin" <?php echo ($user['role'] == 'admin') ? 'selected' : ''; ?>><?php echo __('admin.role_admin', [], $adminLanguage); ?></option>
                                        <option value="manager" <?php echo ($user['role'] == 'manager') ? 'selected' : ''; ?>><?php echo __('admin.role_manager', [], $adminLanguage); ?></option>
                                        <option value="waiter" <?php echo ($user['role'] == 'waiter') ? 'selected' : ''; ?>><?php echo __('admin.role_waiter', [], $adminLanguage); ?></option>
                                    </select>
                                </div>
                                
                                <div class="mb-3 form-check">
                                    <input type="checkbox" class="form-check-input" id="status" name="status" <?php echo ($user['status'] == 1) ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="status"><?php echo __('admin.active', [], $adminLanguage); ?></label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> <?php echo __('admin.save', [], $adminLanguage); ?>
                            </button>
                            <a href="users.php" class="btn btn-secondary">
                                <i class="fas fa-times"></i> <?php echo __('admin.cancel', [], $adminLanguage); ?>
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
    <script src="../assets/js/admin.js"></script>
</body>
</html>
