<?php
/**
 * Dijital Menü - Kullanıcılar Sayfası
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Veritabanı bağlantısını dahil et
require_once '../config/database.php';

// Gerekli dosyaları dahil et
require_once '../includes/auth.php';
require_once '../includes/functions.php';
require_once '../includes/language.php';

// Admin paneli dilini al
$adminLanguage = getAdminLanguage();

// Giriş yapılmamışsa yönlendir
redirectIfNotLoggedIn('login.php');

// Admin yetkisi kontrolü
requirePermission('admin', 'login.php');

// Sayfa başlığı
$pageTitle = __('admin.users', [], $adminLanguage);

// Ayarları al
$settings = getSetting();

// Kullanıcı silme işlemi
if (isset($_GET['delete']) && isset($_GET['id'])) {
    $userId = intval($_GET['id']);
    
    // Kendini silmeye çalışıyorsa engelle
    if ($userId == $_SESSION['user_id']) {
        $_SESSION['error_message'] = __('admin.cannot_delete_self', [], $adminLanguage);
    } else {
        // Kullanıcıyı sil
        $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
        $stmt->bind_param("i", $userId);
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = __('admin.user_deleted', [], $adminLanguage);
        } else {
            $_SESSION['error_message'] = __('admin.user_delete_error', [], $adminLanguage) . ' ' . $conn->error;
        }
    }
    
    redirect('users.php');
}

// Arama ve filtreleme
$search = isset($_GET['search']) ? clean($_GET['search']) : '';
$roleFilter = isset($_GET['role']) ? $_GET['role'] : '';
$statusFilter = isset($_GET['status']) ? $_GET['status'] : '';

// Kullanıcıları al
$sql = "SELECT * FROM users";
$conditions = [];

// Arama filtresi
if (!empty($search)) {
    $conditions[] = "(LOWER(username) LIKE LOWER('%$search%') OR LOWER(email) LIKE LOWER('%$search%') OR LOWER(name) LIKE LOWER('%$search%'))";
}

// Rol filtresi
if (!empty($roleFilter)) {
    $conditions[] = "role = '$roleFilter'";
}

// Durum filtresi
if ($statusFilter !== '') {
    $conditions[] = "status = " . intval($statusFilter);
}

// Koşulları SQL sorgusuna ekle
if (!empty($conditions)) {
    $sql .= " WHERE " . implode(" AND ", $conditions);
}

// Sıralama
$sql .= " ORDER BY id ASC";

// Sorguyu çalıştır
$result = $conn->query($sql);
$users = [];

while ($row = $result->fetch_assoc()) {
    $users[] = $row;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> | <?php echo $settings['site_title'] ?? 'Dijital Menü'; ?></title>
    
    <!-- Favicon -->
    <?php if (!empty($settings['favicon'])): ?>
    <link rel="shortcut icon" href="../assets/img/<?php echo $settings['favicon']; ?>" type="image/x-icon">
    <?php endif; ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Ana CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/admin.css" rel="stylesheet">
    
    <!-- Özel Renkler -->
    <style>
        :root {
            --primary-color: <?php echo $settings['primary_color'] ?? '#3490dc'; ?>;
            --secondary-color: <?php echo $settings['secondary_color'] ?? '#38c172'; ?>;
            --text-color: <?php echo $settings['text_color'] ?? '#333333'; ?>;
            --background-color: <?php echo $settings['background_color'] ?? '#ffffff'; ?>;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'includes/sidebar.php'; ?>
            
            <!-- Ana İçerik -->
            <div class="col-md-9 col-lg-10 admin-content">
                <!-- Üst Başlık -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3"><?php echo $pageTitle; ?></h1>
                    <a href="user-add.php" class="btn btn-primary">
                        <i class="fas fa-plus-circle"></i> <?php echo __('admin.add_user', [], $adminLanguage); ?>
                    </a>
                </div>
                
                <!-- Arama ve Filtre -->
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="get" action="users.php" class="row g-3">
                            <div class="col-md-4">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="search" placeholder="<?php echo __('admin.search', [], $adminLanguage); ?>..." value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>">
                                    <button class="btn btn-outline-secondary" type="submit">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <select class="form-select" name="role">
                                    <option value=""><?php echo __('admin.all_roles', [], $adminLanguage); ?></option>
                                    <option value="admin" <?php echo (isset($_GET['role']) && $_GET['role'] == 'admin') ? 'selected' : ''; ?>><?php echo __('admin.role_admin', [], $adminLanguage); ?></option>
                                    <option value="manager" <?php echo (isset($_GET['role']) && $_GET['role'] == 'manager') ? 'selected' : ''; ?>><?php echo __('admin.role_manager', [], $adminLanguage); ?></option>
                                    <option value="waiter" <?php echo (isset($_GET['role']) && $_GET['role'] == 'waiter') ? 'selected' : ''; ?>><?php echo __('admin.role_waiter', [], $adminLanguage); ?></option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select class="form-select" name="status">
                                    <option value=""><?php echo __('admin.all_status', [], $adminLanguage); ?></option>
                                    <option value="1" <?php echo (isset($_GET['status']) && $_GET['status'] == '1') ? 'selected' : ''; ?>><?php echo __('admin.active', [], $adminLanguage); ?></option>
                                    <option value="0" <?php echo (isset($_GET['status']) && $_GET['status'] == '0') ? 'selected' : ''; ?>><?php echo __('admin.inactive', [], $adminLanguage); ?></option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <a href="users.php" class="btn btn-outline-secondary w-100">
                                    <i class="fas fa-redo"></i> <?php echo __('admin.reset', [], $adminLanguage); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
                
                <!-- Oturum Mesajı -->
                <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['error_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['error_message']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['success_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['success_message']); ?>
                <?php endif; ?>
                
                <!-- İçerik -->
                <div class="admin-card">
                    <!-- Kullanıcı Listesi -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th><?php echo __('admin.id', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.username', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.name', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.email', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.role', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.status', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.last_login', [], $adminLanguage); ?></th>
                                    <th><?php echo __('admin.actions', [], $adminLanguage); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($users)): ?>
                                <tr>
                                    <td colspan="8" class="text-center"><?php echo __('admin.no_users', [], $adminLanguage); ?></td>
                                </tr>
                                <?php else: ?>
                                <?php foreach ($users as $u): ?>
                                <tr>
                                    <td><?php echo $u['id']; ?></td>
                                    <td><?php echo $u['username']; ?></td>
                                    <td><?php echo $u['name']; ?></td>
                                    <td><?php echo $u['email']; ?></td>
                                    <td>
                                        <?php if ($u['role'] == 'admin'): ?>
                                        <span class="badge bg-danger"><?php echo __('admin.role_admin', [], $adminLanguage); ?></span>
                                        <?php elseif ($u['role'] == 'manager'): ?>
                                        <span class="badge bg-warning"><?php echo __('admin.role_manager', [], $adminLanguage); ?></span>
                                        <?php else: ?>
                                        <span class="badge bg-info"><?php echo __('admin.role_waiter', [], $adminLanguage); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($u['status'] == 1): ?>
                                        <span class="badge bg-success"><?php echo __('admin.active', [], $adminLanguage); ?></span>
                                        <?php else: ?>
                                        <span class="badge bg-danger"><?php echo __('admin.inactive', [], $adminLanguage); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo $u['last_login'] ? date('d.m.Y H:i', strtotime($u['last_login'])) : '-'; ?>
                                    </td>
                                    <td>
                                        <a href="user-edit.php?id=<?php echo $u['id']; ?>" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php if ($u['id'] != $_SESSION['user_id']): ?>
                                        <a href="users.php?delete=1&id=<?php echo $u['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('<?php echo __('admin.confirm_delete', [], $adminLanguage); ?>');">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Ana JS -->
    <script src="../assets/js/script.js"></script>
    <script src="../assets/js/admin.js"></script>
</body>
</html>
