/**
 * Geri Bildirim Formu jQuery
 */

$(document).ready(function() {
    // Geri bildirim formunu seç
    const $feedbackForm = $('#feedbackForm');
    
    if ($feedbackForm.length) {
        // Form gönderildiğinde
        $feedbackForm.on('submit', function(e) {
            e.preventDefault();
            
            // Gönder butonunu devre dışı bırak
            const $submitButton = $feedbackForm.find('button[type="submit"]');
            $submitButton.prop('disabled', true)
                        .html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Gönderiliyor...');
            
            // Sonuç alanını seç
            const $resultDiv = $('#feedbackResult');
            
            // AJAX isteği gönder
            $.ajax({
                url: 'save_feedback.php',
                type: 'POST',
                data: $feedbackForm.serialize(),
                dataType: 'json',
                success: function(data) {
                    // Gönder butonunu tekrar etkinleştir
                    $submitButton.prop('disabled', false).html('Gönder');
                    
                    // Sonucu göster
                    if (data.success) {
                        $resultDiv.html('<div class="alert alert-success">' + data.message + '</div>');
                        
                        // Formu temizle
                        $feedbackForm[0].reset();
                        
                        // 3 saniye sonra sonuç mesajını gizle
                        setTimeout(function() {
                            $resultDiv.html('');
                        }, 3000);
                    } else {
                        $resultDiv.html('<div class="alert alert-danger">' + data.message + '</div>');
                    }
                },
                error: function(xhr, status, error) {
                    // Hata durumunda
                    $submitButton.prop('disabled', false).html('Gönder');
                    $resultDiv.html('<div class="alert alert-danger">Bir hata oluştu. Lütfen daha sonra tekrar deneyiniz.</div>');
                    console.error('Error:', error);
                }
            });
        });
    }
    
    // Bilgi butonuna tıklandığında geri bildirim formunu temizle
    $('.bottom-menu-item[onclick*="toggleInfo"]').on('click', function() {
        if ($('#feedbackForm').length) {
            $('#feedbackForm')[0].reset();
            $('#feedbackResult').html('');
        }
    });
    
    // Accordion işlevselliği
    console.log('Accordion işlevselliği başlatılıyor...');
    
    // Sayfa tamamen yüklendikten sonra çalıştır
    $(window).on('load', function() {
        console.log('Sayfa tamamen yüklendi, accordion ayarlanıyor');
        
        const $feedbackAccordionHeader = $('#feedbackAccordionHeader');
        const $feedbackAccordionContent = $('#feedbackAccordionContent');
        
        console.log('Accordion elementleri:', {
            header: $feedbackAccordionHeader.length ? 'Bulundu' : 'Bulunamadı',
            content: $feedbackAccordionContent.length ? 'Bulundu' : 'Bulunamadı'
        });
        
        // Başlangıçta içeriği gizle
        $feedbackAccordionContent.hide();
        
        // Tıklama olayını ekle
        $feedbackAccordionHeader.on('click', function() {
            console.log('Accordion başlığına tıklandı');
            $(this).toggleClass('active');
            
            if ($(this).hasClass('active')) {
                console.log('Accordion açılıyor');
                $feedbackAccordionContent.slideDown(300);
            } else {
                console.log('Accordion kapanıyor');
                $feedbackAccordionContent.slideUp(300);
            }
            
            // Chevron ikonunu döndür
            $(this).find('.accordion-icon').css('transform', 
                $(this).hasClass('active') ? 'rotate(180deg)' : 'rotate(0deg)');
        });
        
        // Manuel olarak tıklama olayını tetikle (test için)
        // setTimeout(function() {
        //     console.log('Manuel tıklama tetikleniyor');
        //     $feedbackAccordionHeader.trigger('click');
        // }, 2000);
    });
});
