<?php
/**
 * Dijital Menü - Ürün Puanlama İşlemi
 */

// İstanbul saatini ayarla
date_default_timezone_set('Europe/Istanbul');

// Gerekli dosyaları dahil et
require_once 'includes/functions.php';

// AJAX isteği kontrolü
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('HTTP/1.1 405 Method Not Allowed');
    exit('Method Not Allowed');
}

// Yanıt formatını ayarla
header('Content-Type: application/json');

// Form verilerini al
$itemId = isset($_POST['item_id']) ? intval($_POST['item_id']) : 0;
$rating = isset($_POST['rating']) ? intval($_POST['rating']) : 0;
$userName = isset($_POST['user_name']) ? clean($_POST['user_name']) : '';
$comment = isset($_POST['comment']) ? clean($_POST['comment']) : '';

// Validasyon
if ($itemId <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz ürün.']);
    exit;
}

// Ayarlardan min/max puanı al
$settings = getSetting();
$minRating = isset($settings['min_rating']) ? intval($settings['min_rating']) : 1;
$maxRating = isset($settings['max_rating']) ? intval($settings['max_rating']) : 5;

if ($rating < $minRating || $rating > $maxRating) {
    echo json_encode(['success' => false, 'message' => "Puan $minRating ile $maxRating arasında olmalıdır."]);
    exit;
}

// İsim artık zorunlu değil
if (empty($userName)) {
    $userName = 'Misafir';
}

// Ürünün var olup olmadığını kontrol et
$stmt = $conn->prepare("SELECT id, name FROM items WHERE id = ? AND status = 1");
$stmt->bind_param("i", $itemId);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Ürün bulunamadı.']);
    exit;
}

$item = $result->fetch_assoc();

// Kullanıcının IP adresini al
$ipAddress = $_SERVER['REMOTE_ADDR'];

// Kullanıcının daha önce bu ürüne puan verip vermediğini kontrol et
if (hasUserRatedItem($itemId, $ipAddress)) {
    echo json_encode(['success' => false, 'message' => 'Bu ürüne daha önce puan verdiniz.']);
    exit;
}

// Puanlamayı ekle
if (addRating($itemId, $rating, $comment, $userName, $ipAddress)) {
    // Puanlama başarılı
    
    // Puanlama onay gerekiyorsa bilgi mesajı göster
    $requireApproval = getSetting('require_approval') ?? '1';
    
    if ($requireApproval == '1') {
        echo json_encode([
            'success' => true, 
            'message' => 'Puanlamanız için teşekkürler!'
        ]);
        exit;
    }
    
    // Onay gerekmiyorsa güncel puanlama bilgilerini al
    $average = getItemAverageRating($itemId);
    $count = getItemRatingCount($itemId);
    
    // Puanlama listesi HTML'ini oluştur
    $ratings = getItemRatings($itemId);
    $html = '';
    
    foreach ($ratings as $r) {
        $html .= '<div class="rating-item">';
        $html .= '<div class="d-flex align-items-center">';
        $html .= '<div class="user-name">' . htmlspecialchars($r['user_name']) . '</div>';
        $html .= '<div class="rating-date">' . formatDate($r['created_at']) . '</div>';
        $html .= '</div>';
        $html .= '<div class="star-rating">' . generateStarRating($r['rating']) . '</div>';
        
        if (!empty($r['comment'])) {
            $html .= '<div class="rating-comment">' . nl2br(htmlspecialchars($r['comment'])) . '</div>';
        }
        
        $html .= '</div>';
    }
    
    echo json_encode([
        'success' => true, 
        'message' => 'Puanlamanız için teşekkürler!',
        'average' => $average,
        'count' => $count,
        'html' => $html
    ]);
} else {
    // Puanlama başarısız
    echo json_encode(['success' => false, 'message' => 'Puanlama eklenirken bir hata oluştu. Lütfen tekrar deneyin.']);
}
