<?php
/**
 * Geri Bildirim Kaydetme Endpoint'i
 */

// Gerekli dosyaları dahil et
require_once 'config/database.php';
require_once 'includes/feedback_functions.php';
require_once 'includes/functions.php';

// Ayarları al
$settings = getSetting();

// Geri bildirim özelliği etkin değilse
if (!isset($settings['enable_feedback']) || $settings['enable_feedback'] != 1) {
    echo json_encode(['success' => false, 'message' => 'Geri bildirim özelliği şu anda devre dışı.']);
    exit;
}

// AJAX isteği kontrolü
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
// CSRF koruması - geçici olarak devre dışı bırakıldı
// if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
//     echo json_encode(['success' => false, 'message' => 'Geçersiz CSRF token.']);
//     exit;
// }
    
    // Form verilerini al
    $name = isset($_POST['name']) ? trim($_POST['name']) : '';
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $message = isset($_POST['message']) ? trim($_POST['message']) : '';
    
    // Validasyon
    $errors = [];
    
    // Mesaj zorunlu
    if (empty($message)) {
        $errors[] = 'Mesaj alanı zorunludur.';
    }
    
    // E-posta formatı kontrolü
    if (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = 'Geçerli bir e-posta adresi giriniz.';
    }
    
    // Hata varsa
    if (!empty($errors)) {
        echo json_encode(['success' => false, 'message' => implode('<br>', $errors)]);
        exit;
    }
    
    // Geri bildirimi kaydet
    $result = addFeedback($name, $email, $message);
    
    // Sonucu döndür
    if ($result) {
        echo json_encode(['success' => true, 'message' => 'Geri bildiriminiz için teşekkürler! En kısa sürede incelenecektir.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Geri bildirim kaydedilirken bir hata oluştu. Lütfen daha sonra tekrar deneyiniz.']);
    }
} else {
    // POST isteği değilse
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek.']);
}
