<?php
session_start();
require_once '../config/db.php';
require_once '../includes/functions.php';

// Admin giriş kontrolü
if (!isLoggedIn()) {
    redirectToLogin();
}

// Site ayarlarını getir
$siteSettings = getSiteSettings($conn);
$siteTitle = $siteSettings['site_title'] ?? 'Restoran Menü';
$faviconImage = $siteSettings['favicon_image'] ?? '';

// Ürün silme işlemi
if (isset($_GET['delete']) && !empty($_GET['delete'])) {
    $id = intval($_GET['delete']);
    
    // Önce ürün bilgilerini al (resim silmek için)
    $stmt = $conn->prepare("SELECT image FROM products WHERE id = :id");
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    $product = $stmt->fetch();
    
    // Ürünü sil
    $stmt = $conn->prepare("DELETE FROM products WHERE id = :id");
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        // Ürün resmi varsa sil
        if (!empty($product['image'])) {
            $image_path = "../uploads/" . $product['image'];
            if (file_exists($image_path)) {
                unlink($image_path);
            }
        }
        
        $delete_success = "Ürün başarıyla silindi.";
    } else {
        $delete_error = "Ürün silinirken bir hata oluştu.";
    }
}

// Öne çıkan ürün işlemi
if (isset($_GET['toggle_featured']) && !empty($_GET['toggle_featured'])) {
    $id = intval($_GET['toggle_featured']);
    
    // Önce ürünün mevcut durumunu kontrol et
    $stmt = $conn->prepare("SELECT featured FROM products WHERE id = :id");
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    $product = $stmt->fetch();
    
    // Durumu tersine çevir
    $featured = $product['featured'] ? 0 : 1;
    
    // Güncelle
    $stmt = $conn->prepare("UPDATE products SET featured = :featured WHERE id = :id");
    $stmt->bindParam(':featured', $featured, PDO::PARAM_INT);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        $featured_success = $featured ? "Ürün öne çıkarıldı." : "Ürün öne çıkarılanlardan kaldırıldı.";
    } else {
        $featured_error = "Ürün durumu güncellenirken bir hata oluştu.";
    }
}

// Sıralama işlemi
if (isset($_GET['move']) && !empty($_GET['move']) && isset($_GET['direction'])) {
    $id = intval($_GET['move']);
    $direction = $_GET['direction'];
    
    // Ürün bilgilerini al
    $stmt = $conn->prepare("SELECT id, category_id, sort_order FROM products WHERE id = :id");
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    $product = $stmt->fetch();
    
    if ($product) {
        $current_order = $product['sort_order'];
        $new_order = ($direction === 'up') ? $current_order - 1 : $current_order + 1;
        
        // Yeni sıra numarası 0'dan küçük olamaz
         if ($new_order >= 0) {
            // Diğer ürünü güncelle (yer değiştirme)
            $stmt = $conn->prepare("UPDATE products SET sort_order = :current_order WHERE category_id = :category_id AND sort_order = :new_order");
            $stmt->bindParam(':current_order', $current_order, PDO::PARAM_INT);
            $stmt->bindParam(':category_id', $product['category_id'], PDO::PARAM_INT);
            $stmt->bindParam(':new_order', $new_order, PDO::PARAM_INT);
            $stmt->execute();
            
            // Bu ürünü güncelle
            $stmt = $conn->prepare("UPDATE products SET sort_order = :new_order WHERE id = :id");
            $stmt->bindParam(':new_order', $new_order, PDO::PARAM_INT);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();
            
            $sort_success = "Ürün sıralaması güncellendi.";
        } else {
            $sort_error = "Ürün zaten en üstte.";
        }
    }
}

// Ürünleri getir
$stmt = $conn->prepare("SELECT p.*, c.name as category_name FROM products p 
                       LEFT JOIN categories c ON p.category_id = c.id 
                       ORDER BY p.category_id ASC, p.sort_order ASC");
$stmt->execute();
$products = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ürünler - <?= $siteTitle; ?></title>
    <?php if (!empty($faviconImage)): ?>
        <?php if (filter_var($faviconImage, FILTER_VALIDATE_URL)): ?>
            <link rel="icon" href="<?= $faviconImage; ?>" type="image/x-icon">
            <link rel="shortcut icon" href="<?= $faviconImage; ?>" type="image/x-icon">
        <?php else: ?>
            <link rel="icon" href="../uploads/<?= $faviconImage; ?>?v=<?= time(); ?>" type="image/x-icon">
            <link rel="shortcut icon" href="../uploads/<?= $faviconImage; ?>?v=<?= time(); ?>" type="image/x-icon">
        <?php endif; ?>
    <?php else: ?>
        <link rel="icon" href="../assets/img/favicon.ico" type="image/x-icon">
        <link rel="shortcut icon" href="../assets/img/favicon.ico" type="image/x-icon">
    <?php endif; ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.css">
    <style>
        /* Öne çıkan ürün yıldızı için özel stil */
        .btn-featured {
            background: linear-gradient(145deg, #FFD700, #FFC107);
            color: #5D4037;
            border-color: rgba(255, 215, 0, 0.6);
            text-shadow: 0 1px 1px rgba(255, 255, 255, 0.3);
            box-shadow: 0 2px 5px rgba(255, 193, 7, 0.4);
        }
        .btn-featured:hover {
            background: linear-gradient(145deg, #FFC107, #FF9800);
            color: #3E2723;
            border-color: rgba(255, 193, 7, 0.8);
            box-shadow: 0 3px 8px rgba(255, 152, 0, 0.5);
        }
        .btn-outline-featured {
            background: transparent;
            color: #FFC107;
            border-color: #FFC107;
        }
        .btn-outline-featured:hover {
            background: rgba(255, 193, 7, 0.1);
            color: #FF9800;
            border-color: #FF9800;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Ürünler</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="add_product.php" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus-circle me-1"></i> Yeni Ürün Ekle
                        </a>
                    </div>
                </div>
                
                <?php if (isset($delete_error)): ?>
                    <div class="alert alert-danger"><?= $delete_error; ?></div>
                <?php endif; ?>
                
                <?php if (isset($delete_success)): ?>
                    <div class="alert alert-success"><?= $delete_success; ?></div>
                <?php endif; ?>
                
                <?php if (isset($featured_error)): ?>
                    <div class="alert alert-danger"><?= $featured_error; ?></div>
                <?php endif; ?>
                
                <?php if (isset($featured_success)): ?>
                    <div class="alert alert-success"><?= $featured_success; ?></div>
                <?php endif; ?>
                
                <?php if (isset($sort_error)): ?>
                    <div class="alert alert-danger"><?= $sort_error; ?></div>
                <?php endif; ?>
                
                <?php if (isset($sort_success)): ?>
                    <div class="alert alert-success"><?= $sort_success; ?></div>
                <?php endif; ?>
                
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th width="5%">Sıra</th>
                                        <th width="5%">ID</th>
                                        <th width="10%">Resim</th>
                                        <th width="15%">Ürün Adı</th>
                                        <th width="15%">Kategori</th>
                                        <th width="10%">Fiyat</th>
                                        <th width="10%">Durum</th>
                                        <th width="10%">Öne Çıkan</th>
                                        <th width="20%">İşlemler</th>
                                    </tr>
                                </thead>
                                <tbody id="sortable-products">
                                    <?php if (count($products) > 0): ?>
                                        <?php 
                                        $current_category = null;
                                        foreach ($products as $product): 
                                            // Kategori değiştiyse başlık ekle
                                            if ($current_category !== $product['category_id']):
                                                $current_category = $product['category_id'];
                                        ?>
                                            <tr class="table-secondary">
                                                <td colspan="9"><strong><?= $product['category_name']; ?></strong></td>
                                            </tr>
                                        <?php endif; ?>
                                            <tr class="sortable-item" data-id="<?= $product['id']; ?>" data-category="<?= $product['category_id']; ?>">
                                                <td>
                                                    <div class="d-flex">
                                                        <span class="sortable-handle me-2"><i class="fas fa-grip-vertical"></i></span>
                                                        <div class="btn-group-vertical btn-group-sm">
                                                            <a href="products.php?move=<?= $product['id']; ?>&direction=up" class="btn btn-outline-secondary btn-sm sort-btn">
                                                                <i class="fas fa-chevron-up"></i>
                                                            </a>
                                                            <a href="products.php?move=<?= $product['id']; ?>&direction=down" class="btn btn-outline-secondary btn-sm sort-btn">
                                                                <i class="fas fa-chevron-down"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><?= $product['id']; ?></td>
                                                <td>
                                                    <?php if (!empty($product['image'])): ?>
                                                        <img src="../uploads/<?= $product['image']; ?>?v=<?= time(); ?>" alt="<?= $product['name']; ?>" width="50" height="50" class="img-thumbnail">
                                                    <?php else: ?>
                                                        <img src="../assets/img/no-image.jpg" alt="Resim Yok" width="50" height="50" class="img-thumbnail">
                                                    <?php endif; ?>
                                                </td>
                                                <td><?= $product['name']; ?></td>
                                                <td><?= $product['category_name']; ?></td>
                                                <td><?= number_format($product['price'], 2); ?> ₺</td>
                                                <td>
                                                    <?php if ($product['status'] == 1): ?>
                                                        <span class="badge bg-success"> Aktif</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-danger">Pasif</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <a href="products.php?toggle_featured=<?= $product['id']; ?>" class="btn btn-sm <?= $product['featured'] ? 'btn-featured' : 'btn-outline-featured'; ?>" title="<?= $product['featured'] ? 'Öne çıkarılanlardan kaldır' : 'Öne çıkar'; ?>">
                                                        <i class="fas fa-star"></i>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="edit_product.php?id=<?= $product['id']; ?>" class="btn btn-sm btn-primary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="products.php?delete=<?= $product['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu ürünü silmek istediğinize emin misiniz?')">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="9" class="text-center">Henüz ürün bulunmamaktadır.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
    <script src="../assets/js/admin.js"></script>
    <script>
        // Sürükle bırak sıralama
        document.addEventListener('DOMContentLoaded', function() {
            const sortableList = document.getElementById('sortable-products');
            if (sortableList) {
                // Kategori başlıklarını hariç tut
                const sortableGroups = {};
                
                // Her kategori için ayrı bir Sortable instance oluştur
                const categories = [...new Set(Array.from(sortableList.querySelectorAll('.sortable-item')).map(item => item.dataset.category))];
                
                categories.forEach(categoryId => {
                    const categoryItems = Array.from(sortableList.querySelectorAll(`.sortable-item[data-category="${categoryId}"]`));
                    if (categoryItems.length > 0) {
                        const group = new Sortable(sortableList, {
                            handle: '.sortable-handle',
                            animation: 150,
                            filter: '.table-secondary', // Kategori başlıklarını hariç tut
                            onMove: function(evt) {
                                // Sadece aynı kategorideki öğelerin sıralanmasına izin ver
                                return evt.related.classList.contains('sortable-item') && 
                                       evt.related.dataset.category === evt.dragged.dataset.category;
                            },
                            onEnd: function(evt) {
                                if (evt.oldIndex !== evt.newIndex) {
                                    const categoryId = evt.item.dataset.category;
                                    const items = Array.from(sortableList.querySelectorAll(`.sortable-item[data-category="${categoryId}"]`));
                                    const ids = items.map(item => item.dataset.id);
                                    
                                    // AJAX ile sıralamayı güncelle
                                    fetch('update_product_order.php', {
                                        method: 'POST',
                                        headers: {
                                            'Content-Type': 'application/json',
                                        },
                                        body: JSON.stringify({ 
                                            ids: ids,
                                            category_id: categoryId
                                        })
                                    })
                                    .then(response => response.json())
                                    .then(data => {
                                        if (data.success) {
                                            // Başarılı mesajı göster
                                            const alert = document.createElement('div');
                                            alert.className = 'alert alert-success';
                                            alert.textContent = 'Ürün sıralaması güncellendi.';
                                            
                                            const mainContent = document.querySelector('main');
                                            mainContent.insertBefore(alert, mainContent.firstChild.nextSibling);
                                            
                                            // 3 saniye sonra mesajı kaldır
                                            setTimeout(() => {
                                                alert.remove();
                                            }, 3000);
                                        }
                                    })
                                    .catch(error => {
                                        console.error('Error:', error);
                                    });
                                }
                            }
                        });
                        
                        sortableGroups[categoryId] = group;
                    }
                });
            }
        });
    </script>
</body>
</html>