<?php
session_start();
require_once '../config/db.php';
require_once '../includes/functions.php';

// Admin giriş kontrolü
if (!isLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// JSON verilerini al
$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || !isset($data['ids']) || !is_array($data['ids'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit;
}

// Kategori sıralamasını güncelle
$success = true;

try {
    $conn->beginTransaction();
    
    foreach ($data['ids'] as $index => $id) {
        $stmt = $conn->prepare("UPDATE categories SET sort_order = :sort_order WHERE id = :id");
        $stmt->bindParam(':sort_order', $index, PDO::PARAM_INT);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
    }
    
    $conn->commit();
} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    $success = false;
    error_log("Kategori sıralama hatası: " . $e->getMessage());
}

// Sonucu döndür
header('Content-Type: application/json');
echo json_encode(['success' => $success]);