// Admin Panel JavaScript Dosyası
document.addEventListener('DOMContentLoaded', function() {
    // Sayfa yüklendiğinde çalışacak kodlar
    console.log('Admin Panel yüklendi');
    
    // Sidebar toggle için (mobil görünümde)
    const sidebarToggle = document.querySelector('.navbar-toggler');
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', function() {
            document.querySelector('#sidebarMenu').classList.toggle('show');
        });
    }
    
    // Tablo satırları için hover efekti
    const tableRows = document.querySelectorAll('tbody tr');
    
    tableRows.forEach(row => {
        row.addEventListener('mouseenter', function() {
            this.style.backgroundColor = '#f8f9fa';
        });
        
        row.addEventListener('mouseleave', function() {
            this.style.backgroundColor = '';
        });
    });
    
    // Form doğrulama
    const forms = document.querySelectorAll('.needs-validation');
    
    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            
            form.classList.add('was-validated');
        }, false);
    });
    
    // Resim yükleme önizleme
    const imageInputs = document.querySelectorAll('input[type="file"][accept*="image"]');
    
    imageInputs.forEach(input => {
        input.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    const preview = document.createElement('img');
                    preview.src = e.target.result;
                    preview.className = 'img-thumbnail mt-2';
                    preview.style.maxWidth = '200px';
                    
                    const previewContainer = input.parentElement.querySelector('.preview-container');
                    
                    if (previewContainer) {
                        previewContainer.innerHTML = '';
                        previewContainer.appendChild(preview);
                    } else {
                        const newPreviewContainer = document.createElement('div');
                        newPreviewContainer.className = 'preview-container';
                        newPreviewContainer.appendChild(preview);
                        input.parentElement.appendChild(newPreviewContainer);
                    }
                };
                
                reader.readAsDataURL(file);
            }
        });
    });
    
    // Resmi kaldır checkbox'ı için
    const removeImageCheckbox = document.getElementById('remove_image');
    if (removeImageCheckbox) {
        removeImageCheckbox.addEventListener('change', function() {
            const imageInput = document.getElementById('image');
            const currentImage = this.parentElement.parentElement.querySelector('img');
            
            if (this.checked) {
                if (currentImage) {
                    currentImage.style.opacity = '0.3';
                }
                if (imageInput) {
                    imageInput.disabled = true;
                }
            } else {
                if (currentImage) {
                    currentImage.style.opacity = '1';
                }
                if (imageInput) {
                    imageInput.disabled = false;
                }
            }
        });
    }
    
    // Silme işlemi onayı
    const deleteButtons = document.querySelectorAll('a[href*="delete="]');
    
    deleteButtons.forEach(button => {
        button.addEventListener('click', function(e) {
            if (!confirm('Bu öğeyi silmek istediğinize emin misiniz?')) {
                e.preventDefault();
            }
        });
    });

    // Kategori resim seçeneklerini göster/gizle - Genel işleyici
    function initializeImageTypeRadios() {
        const imageTypeRadios = document.querySelectorAll('input[name="image_type"]');
        const unsplashUrlContainer = document.getElementById('unsplash_url_container');
        const customImageContainer = document.getElementById('custom_image_container');
        
        if (imageTypeRadios.length > 0 && (unsplashUrlContainer || customImageContainer)) {
            // Sayfa yüklendiğinde seçili olan radio butonuna göre konteynerları göster/gizle
            function updateContainers() {
                const selectedValue = document.querySelector('input[name="image_type"]:checked').value;
                
                if (unsplashUrlContainer) {
                    if (selectedValue === 'unsplash') {
                        unsplashUrlContainer.classList.remove('d-none');
                        unsplashUrlContainer.classList.add('show');
                    } else {
                        unsplashUrlContainer.classList.add('d-none');
                        unsplashUrlContainer.classList.remove('show');
                    }
                }
                
                if (customImageContainer) {
                    if (selectedValue === 'custom') {
                        customImageContainer.classList.remove('d-none');
                        customImageContainer.classList.add('show');
                    } else {
                        customImageContainer.classList.add('d-none');
                        customImageContainer.classList.remove('show');
                    }
                }
                
                // Ensure file inputs are properly enabled/disabled
                const fileInput = document.getElementById('image');
                if (fileInput) {
                    if (selectedValue === 'custom') {
                        fileInput.disabled = false;
                    } else {
                        fileInput.disabled = false; // Still keep enabled for accessibility
                    }
                }
            }
            
            // İlk yüklemede kontrol et
            updateContainers();
            
            // Radio butonlarına change event listener ekle
            imageTypeRadios.forEach(radio => {
                radio.addEventListener('change', updateContainers);
            });
            
            // Force update after a short delay to ensure DOM is fully loaded
            setTimeout(updateContainers, 100);
        }
    }

    // Sayfa yüklendiğinde resim seçeneklerini başlat
    initializeImageTypeRadios();
    
    // Ensure image preview works correctly
    const imageInput = document.getElementById('image');
    if (imageInput) {
        imageInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const preview = document.getElementById('image-preview');
                    if (preview) {
                        preview.innerHTML = `<img src="${e.target.result}" class="img-thumbnail" style="max-width: 200px;">`;
                        preview.style.display = 'block';
                    }
                }
                reader.readAsDataURL(file);
            }
        });
    }
});