<?php
// Site ayarlarını getir
$siteSettings = getSiteSettings($conn);
$footerText = $siteSettings['footer_text'] ?? '&copy; ' . date('Y') . ' Restoran Menü Sistemi. Tüm hakları saklıdır.';
$contactAddress = $siteSettings['contact_address'] ?? 'Örnek Mahallesi, Örnek Sokak No:123';
$contactPhone = $siteSettings['contact_phone'] ?? '(555) 123-4567';
$contactEmail = $siteSettings['contact_email'] ?? 'info@restoranmenu.com';
$socialFacebook = $siteSettings['social_facebook'] ?? '';
$socialInstagram = $siteSettings['social_instagram'] ?? '';
$socialTwitter = $siteSettings['social_twitter'] ?? '';
$siteTitle = $siteSettings['site_title'] ?? 'Restoran Menü';
$footerColor = $siteSettings['footer_color'] ?? '#212529';
$footerTextColor = $siteSettings['footer_text_color'] ?? '#ffffff';
$showFooterContact = $siteSettings['show_footer_contact'] ?? '1';
$showFooterSocial = $siteSettings['show_footer_social'] ?? '1';
$showFooterLinks = $siteSettings['show_footer_links'] ?? '1';

// Kategori sayfasında mı kontrol et
$isCategory = strpos($_SERVER['PHP_SELF'], 'category.php') !== false;
$baseUrl = $isCategory ? '../' : '';
?>
<footer class="footer-custom py-4 mt-5" style="background-color: <?= $footerColor; ?>; color: <?= $footerTextColor; ?>">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-4">
                <h5><?= safeOutput($siteTitle); ?></h5>
                <p><?= safeOutput($siteSettings['site_description'] ?? 'Modern ve kullanıcı dostu restoran menü yönetim sistemi.'); ?></p>
                
                <?php if ($showFooterSocial == '1' && (!empty($socialFacebook) || !empty($socialInstagram) || !empty($socialTwitter))): ?>
                <div class="social-icons mt-3">
                    <?php if (!empty($socialFacebook)): ?>
                        <a href="<?= safeOutput($socialFacebook); ?>" class="me-3" target="_blank" rel="noopener noreferrer" style="color: <?= $footerTextColor; ?>"><i class="fab fa-facebook-f fa-lg"></i></a>
                    <?php endif; ?>
                    
                    <?php if (!empty($socialInstagram)): ?>
                        <a href="<?= safeOutput($socialInstagram); ?>" class="me-3" target="_blank" rel="noopener noreferrer" style="color: <?= $footerTextColor; ?>"><i class="fab fa-instagram fa-lg"></i></a>
                    <?php endif; ?>
                    
                    <?php if (!empty($socialTwitter)): ?>
                        <a href="<?= safeOutput($socialTwitter); ?>" class="me-3" target="_blank" rel="noopener noreferrer" style="color: <?= $footerTextColor; ?>"><i class="fab fa-twitter fa-lg"></i></a>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
            
            <?php if ($showFooterLinks == '1'): ?>
            <div class="col-md-4">
                <h5>Hızlı Erişim</h5>
                <ul class="list-unstyled">
                    <li><a href="<?= $baseUrl; ?>index.php" style="color: <?= $footerTextColor; ?>; text-decoration: none;">Ana Sayfa</a></li>
                    <?php 
                    // Kategorileri menüde göster
                    $footerCategories = getCategories($conn);
                    $maxCategories = min(count($footerCategories), 4); // En fazla 4 kategori göster
                    
                    for ($i = 0; $i < $maxCategories; $i++): 
                        $cat = $footerCategories[$i];
                    ?>
                    <li>
                        <a href="<?= $baseUrl; ?>kategori/<?= $cat['id']; ?>-<?= $cat['slug']; ?>.html" style="color: <?= $footerTextColor; ?>; text-decoration: none;">
                            <?= safeOutput($cat['name']); ?>
                        </a>
                    </li>
                    <?php endfor; ?>
                    <li><a href="<?= $baseUrl; ?>admin/index.php" style="color: <?= $footerTextColor; ?>; text-decoration: none;">Yönetim Paneli</a></li>
                </ul>
            </div>
            <?php endif; ?>
            
            <?php if ($showFooterContact == '1'): ?>
            <div class="col-md-4">
                <h5>İletişim</h5>
                <address class="mb-0">
                    <p><i class="fas fa-map-marker-alt me-2"></i> <?= safeOutput($contactAddress); ?></p>
                    <p><i class="fas fa-phone me-2"></i> <?= safeOutput($contactPhone); ?></p>
                    <p><i class="fas fa-envelope me-2"></i> <?= safeOutput($contactEmail); ?></p>
                </address>
            </div>
            <?php endif; ?>
        </div>
        <hr style="border-color: <?= $footerTextColor; ?>; opacity: 0.2;">
        <div class="text-center">
            <p class="mb-0"><?= $footerText; ?></p>
        </div>
    </div>
</footer>